#include <ESP8266WiFi.h>
#include <PubSubClient.h>

const char* ssid = "nazwa twojego punktu dostępu Wi-Fi";
const char* password = "hasło do Twojej sieci Wi-Fi";
const char* mqtt_server = "adres IP Twojego MQTT";
const int buttonPin = D6;
const char* topic = "button_1";
const char* message = "Przycisk 1 wcisniety";

WiFiClient espClient;
PubSubClient client(espClient);

void setup() {
  pinMode(buttonPin, INPUT_PULLUP);
  Serial.begin(9600);
  setup_wifi();
  randomSeed(micros());
  client.setServer(mqtt_server, 1883);
}

void loop() {
  if (!client.connected()) {
    reconnect();
  }
  client.loop();
  if (digitalRead(buttonPin) == LOW) {
    Serial.println("Publish button pressed ");
    client.publish(topic, message);
    delay(100);
    while (digitalRead(buttonPin) == LOW) {};
    delay(100);
  }
}

void setup_wifi() {
  Serial.println();
  Serial.print("Connecting to ");
  Serial.println(ssid);
  WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("");
  Serial.println("WiFi connected");
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());
}

void reconnect() {
  // Wykonywanie pętli do ponownego połączenia
  while (!client.connected()) {
    Serial.print("Proba polaczenia sie z MQTT...");
    // Stworzenie losowego ID klienta
    String clientId = "ESP8266Client-";
    clientId += String(random(0xffff), HEX);
    // Próba połączenia
    if (client.connect(clientId.c_str())) {
      Serial.println("Poloczono z MQTT");
    } else {
      Serial.print("Blad, kod bledu=");
      Serial.print(client.state());
      Serial.println(" sprobuj ponownie za 5 sekund.");
      // Poczekaj 5 sekund przed ponowną próbą
      delay(5000);
    }
  }
}
