import time, os 
import requests

MAX_TEMP = 37.0
MIN_T_BETWEEN_WARNINGS = 60 # Minuty

BASE_URL = 'https://api.thingspeak.com/apps/thingtweet/1/statuses/update/'
KEY = 'wklej_swoj_klucz_tutaj'

def send_notification(temp):
    status = 'Thingtweet: Raspberry Pi staje sie goracy. Temperatura procesora=' + str(temp)
    data = {'api_key' : KEY, 'status' : status}
    response = requests.post(BASE_URL, json=data)
    print(response.status_code)

def cpu_temp():
    dev = os.popen('/opt/vc/bin/vcgencmd measure_temp')
    cpu_temp = dev.read()[5:-3]
    return float(cpu_temp)
    
while True:
    temp = cpu_temp()
    print("Temperatura procesora (C): " + str(temp))
    if temp > MAX_TEMP:
        print("PROCESOR JEST ZBYT GORACY!")
        send_notification(temp)
        print("Brak powiadomien przez: " + str(MIN_T_BETWEEN_WARNINGS) + " minut")
        time.sleep(MIN_T_BETWEEN_WARNINGS * 60)
    time.sleep(1)

