import piface.pfio as pfio
import espeak as talker

VERBOSE_MODE = True

class Chicken():
    # Chodzący i mówiący kurczak
    def __init__(self, pfio, pin):
        pfio.init()
        self.pfio = pfio
        self.relay_pin = pin
        
    def start_wobble(self):
        # Początek poruszania się kurczaka
        self.pfio.digital_write(self.relay_pin,1)
        if VERBOSE_MODE:
            print "Kurczak zaczął chodzić."
        
    def stop_wobble(self):
        # Zakończenie ruchu kurczaka
        self.pfio.digital_write(self.relay_pin,0)
        if VERBOSE_MODE:
            print "Kurczak przestał chodzić."
            
    def say(self, text_to_say):
        # Sprawianie, aby kurczak zaczął mówić
        if VERBOSE_MODE:
            print "Kurczak mówi: %s" % text_to_say
        talker.say(text_to_say)
        
def test_chicken():
    # Tworzenie przykładowego obiektu tweetyPi typu Chicken
    tweetyPi = Chicken(pfio,1)
    tweetyPi.start_wobble()
    tweetyPi.say("Witaj, świecie")
    tweetyPi.stop_wobble()
    
if __name__ == '__main__':
    test_chicken()

