/* Harmonograf. Wczytywanie danych z czterech enkoderów obrotowych.
Mike Cook, luty – kwiecień 2013.
Manipulowanie bitami interfejsu SPI.
Wysyłanie danych wyjściowych do portu szeregowego jako dwóch 10-bitowych 
wartości rozdzielonych na dwie 5-bitowe. Dwa pierwsze bity służą do identyfikowania
bajtu. 
Transfer danych i sterowanie konfiguracją odbywają się szeregowo.
*/

#define CS_ENC 10
#define CK_ENC 13
#define MISO_ENC 12
#define MOSI_ENC 11

// Stałe służące do skalowania danych wyjściowych 
#define OFFSET 400.0  // Środek ekranu
#define H_OFFSET 200.0 // Przesunięcie o połowę
#define RANGE 540.0  // Zakres współrzędnych (na plus i na minus)
#define H_RANGE 270.0   // Połowa zakresu współrzędnej x przy używaniu dwóch wahadeł

long int interval, timeToSample;
float th [] = {0.0, 0.0, 0.0, 0.0 }; // Odczyt kąta
// Zmodyfikuj poniższy wiersz na podstawie własnych pomiarów
int offset[] = {521, 510, 380, 477}; // Przesunięcia przy wartości zero stopni
int reading[4]; // Przechowywanie nieprzetworzonych odczytów
boolean active = false, calabrate = false;
byte np = 2; // Liczba wahadeł na wyjściu
byte npRead = 4; // Liczba sprawdzanych czujników
byte ledRed [] = {2, 4, 6, 8}; // Piny sterujące czerwoną diodą
byte ledGreen [] = {3, 5, 7, 9}; // Piny sterujące zieloną diodą

void setup(){
  Serial.begin(115200);
  pinMode(CS_ENC, OUTPUT);
  digitalWrite(CS_ENC, HIGH);
  pinMode(CK_ENC, OUTPUT);
  digitalWrite(CK_ENC, HIGH); // Ustawianie zegara na wysoki stan
  pinMode(MOSI_ENC, OUTPUT);
  digitalWrite(MOSI_ENC, LOW);
  pinMode(MISO_ENC, INPUT);
  interval = 20; // Czas między próbkowaniem
  timeToSample = millis() + interval;
    for(int i = 0; i<4; i++){ // Inicjowanie sygnalizacyjnych diod LED
    pinMode(ledRed[i], OUTPUT);
    pinMode(ledGreen[i], OUTPUT);
  }
  upDateLEDs(np);
  delay(100); // Czas na włączenie czujników
  pinMode(A5,OUTPUT);
  digitalWrite(A5,LOW);
  if(calabrate){
     encRead(); // Określanie przesunięcia
     calabrate = false; // Kalibracja zakończona
     }
}

void loop(){
  if(millis() >= timeToSample && active) { // Wysyłanie danych (jeśli program ma to zrobić)
     digitalWrite(13, HIGH);
     timeToSample = millis() + interval;
     encRead();
     sendData();
     digitalWrite(13,LOW);  
   }
  else {
    if(Serial.available() != 0) { // Rozpoczynanie i kończenie wysyłania próbek
      char rx = Serial.read();
      switch (rx) { 
       case'G': // Rozpoczącie wysyłania próbek (G od słowa „go”)
       active = true;
       break;
       case'S': // Zakończenie przesyłania próbek (S od słowa „stop”)
       active = false;
       break;
       case '2': // Próbki z czujnika 1 dla współrzędnej X i czujnika 3 dla współrzędnej Y
       upDateLEDs(0x45);
       np = 2;
       break;
       case '3': // Próbki z czujników 1 i 2 dla współrzędnej X oraz czujnika 3 dla współrzędnej Y
       upDateLEDs(0x47);
       np = 3;
       break;
       case '4': // Próbki z czujników 1 i 2 dla współrzędnej X oraz czujników 3 i 4 dla współrzędnej Y
       upDateLEDs(0xcf);
       np = 4;
       break;
       case '5':
       upDateLEDs(0x8a);
       np = 5;  // Próbki z czujnika 2 dla współrzędnej X i czujnika 4 dla współrzędnej Y
       break;
       case '6': // Próbki z czujnika 1 dla współrzędnej X oraz czujników 3 i 4 dla współrzędnej Y
       upDateLEDs(0xCD);
       np = 6;
       break;

    }    
  }  
 }
}

void encRead(){ // Wczytywanie dwóch bajtów z każdego enkodera
      int hallReading =  0;
   digitalWrite( CS_ENC, LOW);  // Włączanie enkodera
   for(int i = 0; i<npRead; i++){
        delayMicroseconds(10);
        digitalWrite( CK_ENC, LOW); // Ustawianie zegara na niski stan
        delayMicroseconds(10);
        hallReading =  0;
        for(int i=0;i<16;i++){ // Wczytywanie wszystkich czterech bitów
            hallReading = hallReading << 1;
            digitalWrite( CK_ENC, HIGH); // Ustawianie zegara na wysoki stan
            delayMicroseconds(10);
            hallReading = hallReading | digitalRead(MISO_ENC);
            digitalWrite( CK_ENC, LOW); // Ustawianie zegara na niski stan
            delayMicroseconds(10);     
         } // Wszystkie bity zostały wczytane
         digitalWrite( CK_ENC, HIGH); // Ustawianie zegara na wysoki stan
         delayMicroseconds(10);
         reading[i] = hallReading;
     }
   digitalWrite( CS_ENC, HIGH); // Chip wyłączony
   // Wszystkie dane są gotowe – pora przystąpić do ich przetwarzania
   int errorLEDs = 0;
   for(int i=0; i<npRead; i++){
         th[i] = ((reading[i] >> 6) & 0x3ff) - offset[i]; // Dane określające kąt
         th[i] = th[i] * 0.006135; // Przekształcanie wartości na radiany
         if((reading[i] & 0x6) != 0) errorLEDs++; //  Wyświetlanie błędów
   }
   if(errorLEDs != 0) digitalWrite(A5,HIGH); else digitalWrite(A5,LOW); // Włączanie diody LED sygnalizującej błąd
}

void upDateLEDs(int n){ // Bardziej istotny połbajt – dioda czerwona,
                        // mniej istotny półbajt – dioda zielona
  ledsOff();
  for(int i = 0; i<4; i++){
    if( (n & 1) != 0) digitalWrite(ledGreen[i],HIGH);
    n = n >> 1;
  }
    for(int i = 0; i<4; i++){
    if( (n & 1) != 0) digitalWrite(ledRed[i],HIGH);
    n = n >> 1;
  }
}

void ledsOff(){
    for(int i=0; i<4; i++){
    digitalWrite(ledRed[i], LOW);
    digitalWrite(ledGreen[i], LOW);
  }
}


void sendData() { // Wysyłanie współrzędnych X i Y rysowanego punktu
  int s1,s2;
  byte t;
  // Wahadła 1 i 3 są krótkie, dlatego mają większy zakres
  switch(np) {
    case 2: // Dla dwóch wahadeł
        s1 = OFFSET + (RANGE * sin(th[0]));
        s2 = OFFSET + (RANGE * sin(th[2]));
        break;
    case 3: // Dla trzech wahade
        s1 = OFFSET + (H_RANGE * sin(th[0])) + (H_OFFSET * sin(th[1]));
        s2 = OFFSET + (RANGE * sin(th[2]));
        break;
    case 4: // Dla czterech wahadeł
        s1 = OFFSET + (H_RANGE * sin(th[0])) + (H_OFFSET * sin(th[1]));
        s2 = OFFSET + (H_RANGE * sin(th[2])) + (H_OFFSET * sin(th[3]));
        break;
    case 5: // Dla dwóch innych wahadeł
        s1 = OFFSET + (OFFSET * sin(th[1]));
        s2 = OFFSET + (OFFSET * sin(th[3]));
    case 6: // Dla trzech wahadeł
        s1 = OFFSET + (RANGE * sin(th[0]));
        s2 = OFFSET + (H_RANGE * sin(th[2]) + (H_OFFSET * sin(th[3])));
        break;
  }
  // Dzielenie danych na cztery bajty, oznaczanie dwóch 
  // najbardziej znaczących bitów i wysyłanie danych
  t = (s1 >> 5) & 0x1f; // Najpierw najbardziej znaczący bit
  Serial.write(t);
  t = (s1 & 0x1f) | 0x40; // Najmniej znaczący bit plus pierwsze bity indeksujące
  Serial.write(t);
  t = ((s2 >> 5)  & 0x1f)| 0x80; // Najbardziej znaczący bit plus pierwszy bit indeksujący
  Serial.write(t);
  t = (s2 & 0x1f) | 0xC0; // Najmniej znaczący bit plus pierwsze bity indeksujące
  Serial.write(t);
}
