/* Harmonograf. Wczytywanie danych z czterech enkoderów obrotowych 
i testowanie diod LED.
Mike Cook, luty – kwiecień 2013.
Manipulowanie bitami interfejsu SPI.
*/

// Definiowanie pinów interfejsu SPI
#define CS_ENC 10
#define CK_ENC 13
#define MISO_ENC 12
#define MOSI_ENC 11

long int time;
byte npRead = 4; // Liczba czujników, z których wczytywane są dane
float th [] = {0.0, 0.0, 0.0, 0.0 }; // Odczyt kątów
int dig1 [] = { 0, 0, 0, 0};
int dig2 [] = { 0, 0, 0, 0};
byte ledRed [] = {2, 4, 6, 8}; // Piny kontrolujące diodę czerwoną
byte ledGreen [] = {3, 5, 7, 9}; // Piny kontrolujące diodę zieloną
int count =1; // Wzorzec testowy diod LED 
int error = 1; // Licznik błędów w teście diod LED 

void setup(){
   Serial.begin(9600);
   pinMode(CS_ENC, OUTPUT);
   digitalWrite(CS_ENC, HIGH);
   pinMode(CK_ENC, OUTPUT);
   digitalWrite(CK_ENC, HIGH); // Ustawianie zegara na wysoki stan
   pinMode(MOSI_ENC, OUTPUT);
   digitalWrite(MOSI_ENC, LOW);
   pinMode(MISO_ENC, INPUT);
   pinMode(A5, OUTPUT);
   for(int i=0; i<4; i++){ // Ustawianie diod LED
     pinMode(ledRed[i], OUTPUT);
     digitalWrite(ledRed[i], LOW);
     pinMode(ledGreen[i], OUTPUT);
     digitalWrite(ledGreen[i], LOW);
    }
 time = millis() + 2000; // Wczytywanie danych co dwie sekundy
}

void loop(){
  if(millis() > time){ // Odczyty mają miejsce co dwie sekundy
   time = millis() + 1000; 
   encRead(); // Wczytywanie danych z wszystkich czujników
   for(int i =0; i<npRead; i++){ // Wyświetlanie tych danych
   Serial.print(th[i]); // Kąt
   Serial.print(" -> ");
   Serial.print(dig1[i],HEX);  // Gotowość
   Serial.print(" -> ");
   Serial.println(dig2[i], HEX); // Siła pola magnetycznego
   }
   count = count << 1;
   if(count > 0xff) count = 1;
   upDateLEDs(count);
   error++ ;
   digitalWrite(A5, error & 1); // Migotanie diodą LED sygnalizującą błąd
   Serial.println(" ");
  }
}

void upDateLEDs(int n){ // Bardziej znaczący półbajt – dioda czerwona, 
                        // mniej znaczący półbajt – dioda zielona
  ledsOff();
  for(int i = 0; i<4; i++){
    if( (n & 1) != 0) digitalWrite(ledGreen[i],HIGH);
    n = n >> 1;
  }
    for(int i = 0; i<4; i++){
    if( (n & 1) != 0) digitalWrite(ledRed[i],HIGH);
    n = n >> 1;
  }
}

void ledsOff(){
    for(int i=0; i<4; i++){
    digitalWrite(ledRed[i], LOW);
    digitalWrite(ledGreen[i], LOW);
  }
}

void encRead(){ // Wczytywanie dwóch bajtów z każdego enkodera
   int hallReading; // Zmienna na 16 bitów z czujnika
   digitalWrite( CS_ENC, LOW);  // Włączanie enkoderów
   for(int i = 0; i<npRead; i++){ // Wczytywanie danych z każdego czujnika
        delayMicroseconds(50);
        digitalWrite( CK_ENC, LOW); // Ustawianie zegara na niski stan
        delayMicroseconds(50);
        for(int i=0;i<16;i++){ // Wczytywanie wszystkich bitów z jednego czujnika
            hallReading = hallReading << 1;
            digitalWrite( CK_ENC, HIGH); // Ustawianie zegara na wysoki stan
            delayMicroseconds(50);
            hallReading = hallReading | digitalRead(MISO_ENC);
            digitalWrite( CK_ENC, LOW); // Ustawianie zegara na niski stan
            delayMicroseconds(50);     
         } // Wszystkie bity zostały wczytane
         digitalWrite( CK_ENC, HIGH); // Ustawianie zegara na wysoki stan
         delayMicroseconds(50);
          th[i] = ((hallReading>> 6) & 0x3ff); // Dane określające kąt
          dig1[i] = (hallReading & 0x3f) >> 3; // Pole magnetyczne
          dig2[i] = (hallReading & 0x6)>>1; // Bity gotowości i błędu
   }
   digitalWrite( CS_ENC, HIGH); // Wyłączenie chipu
}

