"""Profil wysokości z zachodu na wschód przez Olympus Mons."""
from PIL import Image, ImageDraw
from matplotlib import pyplot as plt

# Wgrywa obraz i pozyskuje wartości x i z wzdłuż poziomego
# profilu równoległego do y_coord.
y_coord = 202
im = Image.open('mola_1024x512_200mp.jpg').convert('L')
width, height = im.size
x_vals = [x for x in range(width)]
z_vals = [im.getpixel((x, y_coord)) for x in x_vals]

# Rysuje profil na mapie MOLA.
draw = ImageDraw.Draw(im)
draw.line((0, y_coord, width, y_coord), fill=255, width=3)
draw.text((100, 165), 'Olympus Mons', fill=255)
im.show()    

# Rysuje wykres profilu.
fig, ax = plt.subplots(figsize=(9, 4))
axes = plt.gca()
axes.set_ylim(0, 400)
ax.plot(x_vals, z_vals, color='black')
ax.set(xlabel='współrzędna x',
       ylabel='Intensywność (wysokość)',
       title="Profil wysokościowy Marsa (y = 202)")
ratio = 0.15  # Zmniejsza nadmierną wysokość obrazu.
xleft, xright = ax.get_xlim()
ybase, ytop = ax.get_ylim()
ax.set_aspect(abs((xright-xleft)/(ybase-ytop)) * ratio)
plt.text(0, 310, 'ZACHÓD', fontsize=10)
plt.text(930, 310, 'WSCHÓD', fontsize=10)
plt.text(100, 280, 'Olympus Mons', fontsize=8)
##ax.grid()
plt.show()
