"""
Przeprowadza progowanie obrazu w skali szarości 
na podstawie wartości pikseli i zapisuje wynik do pliku.
"""
import cv2 as cv

IMG_GEO = cv.imread('Mars_Global_Geology_Mariner9_1024.jpg', cv.IMREAD_GRAYSCALE)
cv.imshow('map', IMG_GEO)
cv.waitKey(1000)
img_copy = IMG_GEO.copy()
lower_limit = 170  # Najniższa wartość piksela dla obszaru osadów wulkanicznych
upper_limit = 185  # Najwyższa wartość piksela dla obszaru osadów wulkanicznych

# Dla obrazu 1024 x 512
for x in range(1024):
    for y in range(512):
        if lower_limit <= img_copy[y, x] <= upper_limit:
            # Ustaw wartość na 255, aby zwizualizować wyniki.
            img_copy[y, x] = 1
        else:
            img_copy[y, x] = 0

cv.imwrite('geo_thresh.jpg', img_copy)
cv.imshow('thresh', img_copy)
cv.waitKey(0)
