import numpy as np
from PIL import Image
import matplotlib.pyplot as plt
from wordcloud import WordCloud, STOPWORDS

# Wgrywa plik tekstowy jako ciąg znaków.
with open('hound.txt') as infile:
    text = infile.read()

# Wgrywa obraz jako tablicę NumPy.
mask = np.array(Image.open('holmes.png'))

# Pobiera słowa nieindeksowane jako zbiór i dodaje dodatkowe słowa.
stopwords = STOPWORDS
stopwords.update(['us', 'one', 'will', 'said', 'now', 'well', 'man', 'may',
                  'little', 'say', 'must', 'way', 'long', 'yet', 'mean',
                  'put', 'seem', 'asked', 'made', 'half', 'much',
                  'certainly', 'might', 'came'])

# Generuje chmurę słów.
wc = WordCloud(max_words=500,
               relative_scaling=0.5,
               mask=mask,
               background_color='white',
               stopwords=stopwords,
               margin=2,
               random_state=7,
               contour_width=2,
               contour_color='brown',
               colormap='copper').generate(text)

# Przekształca obiekt wc na tablicę.
colors = wc.to_array()

# Wyświetla i zapisuje chmurę słów.
plt.figure()
plt.title("Uczniowie Chamberlain-Hunt Academy prezentują:\n",
          fontsize=15, color='brown')
plt.text(-10, 0, "Pies Baskerville’ów",
         fontsize=20, fontweight='bold', color='brown')
plt.suptitle("10–12 maja, godz. 19.00 — Audytorium McComb",
             x=0.52, y=0.095, fontsize=15, color='brown')
plt.imshow(colors, interpolation="bilinear")
plt.axis('off')
plt.show()
##plt.savefig('hound_wordcloud.png')
