import os
import pyttsx3
import cv2 as cv
from playsound import playsound

# Określa ustawienia dla instrukcji dźwiękowych.
engine = pyttsx3.init()
engine.setProperty('rate', 145)
engine.setProperty('volume', 1.0)  # Maksymalna wartość to 1.0.

# Określa ustawienia dla pliku dźwiękowego.
root_dir = os.path.abspath('.')
tone_path = os.path.join(root_dir, 'tone.wav')

# Określa ścieżkę do klasyfikatorów kaskadowych Haara biblioteki OpenCV.
path = "C:/Python39/Lib/site-packages/cv2/data/"
face_detector = cv.CascadeClassifier(path +
                                     'haarcascade_frontalface_default.xml')

# Przygotowuje kamerę.
cap = cv.VideoCapture(0)
if not cap.isOpened():
    print("Nie mozna uruchomic urzadzenia wideo.")
cap.set(3, 640)  # Szerokość klatki
cap.set(4, 480)  # Wysokość klatki

# Przekazuje instrukcje.
engine.say("Wprowadź swoje dane po otrzymaniu komunikatu na ekranie. \
           Następnie usuń okulary i spójrz bezpośrednio w kamerę. \
           Przybierz różne wyrazy twarzy: normalny, szczęśliwy, \
           smutny, zaspany. \
           Kontynuuj do czasu usłyszenia sygnału.")
engine.runAndWait()
name = input("\nWpisz swoje nazwisko: ")
user_id = input("Wpisz swoj numer identyfikacyjny: ")
print("\nPobieranie obrazow twarzy. Patrz w kamere!")

# Tworzy katalog do przechowywania obrazów.
if not os.path.isdir('trainer'):
    os.mkdir('trainer')
os.chdir('trainer')

frame_count = 0

while True:
    # Pozyskuje obrazy klatka po klatce (w sumie 30 klatek).
    _, frame = cap.read()
    gray = cv.cvtColor(frame, cv.COLOR_BGR2GRAY)
    face_rects = face_detector.detectMultiScale(gray, scaleFactor=1.2,
                                                minNeighbors=5)
    for (x, y, w, h) in face_rects:
        frame_count += 1
        cv.imwrite(str(name) + '.' + str(user_id) + '.'
                   + str(frame_count) + '.jpg', gray[y:y + h, x:x + w])
        cv.rectangle(frame, (x, y), (x + w, y + h), (0, 255, 0), 2)
        # Najlepiej mieć otwarty katalog z miniaturami.
        cv.imshow('image', frame)
        cv.waitKey(400)
    if frame_count >= 30:
        break

print("\nZakonczono pobieranie obrazow. Wyjscie z programu...")
playsound(tone_path, block=False)
cap.release()
cv.destroyAllWindows()
