"""
Zmniejsza obraz do rozmiaru 3 x 3 piksele i tworzy wykres komponentów 
BGR środkowego piksela.
"""
import cv2 as cv
from matplotlib import pyplot as plt

files = ['earth_west.png', 'earth_east.png']

# Zmniejsza obraz do rozmiarów 3 x 3 pikseli.
for file in files:
    img_ini = cv.imread(file)
    pixelated = cv.resize(img_ini, (3, 3), interpolation=cv.INTER_AREA)
    img = cv.resize(pixelated, (300, 300), interpolation=cv.INTER_NEAREST)
    cv.imshow('Obraz {}'.format(file), img)
    cv.waitKey(2000)

    color_values = pixelated[1, 1]  # Wybiera środkowy piksel.
    print(color_values)

    # Tworzy diagramy kołowe.
    labels = 'Niebieski', 'Zielony', 'Czerwony'
    colors = ['blue', 'green', 'red']    
    fig, ax = plt.subplots(figsize=(3.5, 4.0))  # Rozmiar w calach
    _, _, autotexts = ax.pie(color_values,
                             labels=labels,
                             autopct='%1.1f%%',
                             colors=colors)
    for autotext in autotexts:
        autotext.set_color('white')
    plt.title('Środkowy piksel {}\n'.format(file))
    
plt.show()
