"""
Wykorzystuje przetwarzanie języka naturalnego (nltk)
do generowania wykresu rozkładu.
"""
import nltk
from matplotlib import pylab

import file_loader

corpus = file_loader.text_to_string('hound.txt')
tokens = nltk.word_tokenize(corpus)
# nltk.Text to nakładka NLTK do automatycznej analizy tekstu.
tokens = nltk.Text(tokens)

words = ['Holmes',
         'Watson',
         'Mortimer',
         'Henry',
         'Barrymore',
         'Stapleton',
         'Selden',
         'hound']

text = list(tokens)
words.reverse()

points = [
    (x, y)
    for x in range(len(text))
    for y in range(len(words))
    if text[x] == words[y]
]
if points:
    x, y = list(zip(*points))
else:
    x = y = ()
pylab.plot(x, y, "b|", scalex=0.1)
pylab.yticks(list(range(len(words))), words, color="b")
pylab.ylim(-1, len(words))
pylab.title("Wykres rozrzutu leksykalnego")
pylab.xlabel("Przesunięcie względem początku korpusu (w słowach)")
pylab.show()
