﻿################
## LISTING 34.1
################
class Player(object):
    """ gracz """
    def __init__(self, name):
        """ ustawia imię i pusty zestaw kart """
        self.hand = []                      #A
        self.name = name                    #B
    def get_name(self):                     #C
        """ zwraca imię gracza """
        return self.name                    #C
#A Ustala zestaw kart, który na początku jest pustą listą
#B Ustawia imię, które zostanie przekazane w momencie stworzenia obiektu Player
#C Metoda, która zwraca imię gracza



################
## LISTING 34.2
################
class Player(object):
    """ gracz """
    # metoda z listingu 34.1
    def add_card_to_hand(self, card):                #A
        """ card, ciąg znaków 
            Dodaje prawidłową kartę do zestawu kart gracza """
        if card != None:
            self.hand.append(card)                   #A
    def remove_card_from_hand(self, card):           #B
        """ card, ciąg znaków 
            Usuwa kartę z zestawu kart gracza """
        self.hand.remove(card)                       #B
    def hand_size(self):                             #C
        """ Zwraca liczbę kart w zestawie gracza """
        return len(self.hand)                        #C
#A Dokłada kartę do zestawu, dodając ją do listy, o ile karta ma prawidłową wartość i kolor
#B Usuwa kartę z zestawu — odnajduje ją i usuwa z listy
#C Rozmiar zestawu zwraca liczbę elementów na liście





################
## LISTING 34.3
################
class CardDeck(object):
    """ Talia kart 2-9 dla pik, kier, karo, trefl """
    def __init__(self):
        """ talia kart (ciągi, np. "2C" odpowiadają 2 trefl) 
            zawiera wszystkie możliwe karty """
        hearts = "2H,3H,4H,5H,6H,7H,8H,9H"               #A
        diamonds = "2D,3D,4D,5D,6D,7D,8D,9D"             #A
        spades = "2S,3S,4S,5S,6S,7S,8S,9S"               #A
        clubs = "2C,3C,4C,5C,6C,7C,8C,9C"                #A
        self.deck = hearts.split(',')+diamonds.split(',')  +  \     #B
                    spades.split(',')+clubs.split(',')
#A Tworzy ciąg wszystkich możliwych kart w talii
#B Dzieli długi ciąg w miejscu przecinka i dodaje wszystkie karty (ciągi znaków) do listy przechowującej talię 







################
## LISTING 34.4
################
import random

class CardDeck(object):
    """ Talia kart 2-9 pik, kier, karo, trefl """
    def __init__(self):
        """ talia kart (ciąg znaków, np. "2C" dla 2 trefl) 
            zawiera wszystkie możliwe karty """
        hearts = "2H,3H,4H,5H,6H,7H,8H,9H"
        diamonds = "2D,3D,4D,5D,6D,7D,8D,9D"
        spades = "2S,3S,4S,5S,6S,7S,8S,9S"
        clubs = "2C,3C,4C,5C,6C,7C,8C,9C"
        self.deck = hearts.split(',')+diamonds.split(',')        \
                    + spades.split(',')+clubs.split(',')
    def get_card(self):
        """ Zwraca jedną losową kartę (ciąg znaków) oraz 
            zwraca None jeśli nie ma więcej kart """
        if len(self.deck) < 1:                    #A
            return None                           #A
        card = random.choice(self.deck)           #B
        self.deck.remove(card)                    #C
        return card                               #D
    def compare_cards(self, card1, card2):
        """ zwraca wyższą kartę zgodnie z
            (1) wyższą wartością karty albo, jeśli są równe,
            (2) pik > kier > karo > trefl """
        if card1[0] > card2[0]:                    #E
            return card1                           #E
        elif card1[0] < card2[0]:                  #F
            return card2                           #F
        elif card1[1] > card2[1]:                  #G
            return card1                           #G
        else:                                      #G
            return card2                           #G
#A Jeśli nie ma więcej kart w talii, zwraca None
#B Losuje przypadkową kartę z talii
#C Usuwa kartę z talii
#D Zwraca wartość karty (ciąg znaków)
#E Sprawdza wartość karty, zwraca pierwszą kartę, jeśli jest wyższa
#F Sprawdza wartość karty, zwraca drugą kartę, jeśli jest wyższa
#G Kiedy karty są równe pod względem wartości, odwołuje się do koloru


################
## LISTING 34.5
################
name1 = input("Jak masz na imię? Gracz 1: ")      #A
player1 = Player(name1)                           #B

name2 = input("Jak masz na imię? Gracz 2: ")
player2 = Player(name2)

deck = CardDeck()                                 #C
#A Pobiera dane użytkownika — imię gracza 1
#B Tworzy nowy obiekt Player
#C Tworzy nowy obiekt CardDeck


################
## LISTING 34.6
################
name1 = input("Jak masz na imię? Gracz 1: ")
player1 = Player(name1)
name2 = input("Jak masz na imię? Gracz 2: ")
player2 = Player(name2)
deck = CardDeck()

while True:
    player1_card = deck.get_card()
    player2_card = deck.get_card()
    player1.add_card_to_hand(player1_card)
    player2.add_card_to_hand(player2_card)

    if player1_card == None or player2_card == None:          #A
        print("Koniec gry. Nie ma już więcej kart w talii.")
        print(name1, " ma ", player1.hand_size())
        print(name2, " ma ", player2.hand_size())
        print("Kto wygrał?")
        if player1.hand_size() > player2.hand_size():          #B
            print(name2, " wygrywa!")                          #B
        elif player1.hand_size() < player2.hand_size():        #C
            print(name1, " wygrywa!")                          #C
        else:                                                  #D
            print("Remis!")                                    #D
        break                                                  #E
    # porównuje karty graczy i dodaje kartę do talii przegrywającego
    else:                                                      #F
        print(name1, ": ", player1_card)
        print(name2, ": ", player2_card)
        if deck.compare_cards(player1_card,player2_card)==player1_card:  #G
            player2.add_card_to_hand(player1_card)                       #H
            player1.remove_card_from_hand(player1_card)                  #I
        else:
            player1.add_card_to_hand(player2_card)
            player2.remove_card_from_hand(player2_card)
#A Gra się kończy, ponieważ przynajmniej jeden z graczy nie ma już kart
#B Sprawdza liczbę kart w zestawie, player2 wygrywa, ponieważ ma mniej kart
#C Sprawdza liczbę kart w zestawie, player1 wygrywa, ponieważ ma mniej kart
#D Gracze mają tę samą liczbę kart, a więc remis
#E Instrukcja break przerywa pętlę while, kiedy jeden z graczy wygrywa lub jeśli następuje remis
#F Gra może być kontynuowana, ponieważ gracze ciągle dysponują kartami, które można porównywać
#G Porównuje karty między graczami i zwraca kartę o wyższej wartości
#H Wyższa karta należy do player1, wiec dodaje jego kartę do zestawu gracza player2
#I Wyższa karta należy do player1, więc usuwa kartę gracza player1 z jego zestawu
