﻿################
## LISTING 23.1
################
word = "bird\n"                            #A
print(word)                                #B
word = word.replace("\n", "")              #C
print(word)                                #D
#A Tworzy zmienną, której wartość to ciąg zawierający znak nowej linii
#B Wyświetla słowo z przejściem do nowej linii
#C Zastępuje znak nowej linii pustym ciągiem, a wynik przypisuje do tej samej zmiennej
#D Wyświetla słowo bez przejścia do nowej linii




################
## LISTING 23.2
################
def read_file(file):
    """                                                          #A
    file, obiekt typu plik                                       #A
    Począwszy od pierwszej linii, zaczytuje co drugą linię       #A
    i zapisuje do krotki.                                        #A
    Począwszy od drugiej linii, zaczytuje co drugą linię         #A
    i zapisuje do krotki.                                        #A
    Zwraca krotkę składającą się z dwóch krotek.                 #A
    """                                                          #A
    first_every_2 = ()                            #B
    second_every_2 = ()                           #B
    line_count = 0                                        #C
    for line in file:                                     #D
        stripped_line = line.replace("\n", "")            #E
        if line_count%2 == 0:                             #F
            first_every_2 += (stripped_line,)             #G
        elif line_count%2 == 1:                           #H
            second_every_2 += (stripped_line,)            #I
        line_count += 1                                   #J
    return (first_every_2, second_every_2)                #K
#A docstring
#B Puste krotki na nazwiska i numery telefonów
#C Licznik numerów linii
#D Pętla przechodząca po wszystkich liniach
#E Usuwa znak złamania wiersza
#F Linie nieparzyste
#G Dodaje nazwisko do krotki
#H Linie parzyste
#I Dodaje do krotki telefon
#J Zwiększa numer linii o jeden
#K Zwraca krotkę zawierającą krotki


################
## LISTING 23.3
################
def sanitize(some_tuple):
    """ 
    phones, krotka zawierająca ciągi znaków
    Usuwa wszystkie spacje, myślniki, oraz nawiasy otwierające i zamykające
    w każdym ciągu
    Zwraca krotkę z wyczyszczonymi elementami typu string
    """
    clean_string = ()                      #A
    for st in some_tuple:
        st = st.replace(" ", "")           #B
        st = st.replace("-", "")           #B
        st = st.replace("(", "")           #B
        st = st.replace(")", "")           #B
        clean_string += (st,)              #C
    return clean_string                    #D
#B Zamienia niepotrzebne znaki na puste ciągi
#A Puste krotki
#C Dodaje wyczyszczone numery do nowej krotki
#D Zwraca nową krotkę
 


################
## LISTING 23.4
################
friends_file = open('friends.txt')             #A
(names, phones) = read_file(friends_file)      #B

print(names)                                      #C
print(phones)                                     #C
clean_phones = sanitize(phones)                   #D

print(clean_phones)                               #C
friends_file.close()                              #E
#A Otwiera plik
#B Wywołuje funkcję
#C Wyświetla dane użytkownikowi
#D Sprawdza, czy funkcja działa
#E Zamyka plik



################
## LISTING 23.5
################
def get_unique_area_codes():    
    """ 
    Zwraca krotkę zawierającą wszystkie unikalne numery kierunkowe zawarte w krotce phones 
    """
    area_codes = ()                               #A 
    for ph in phones:                             #B
        if ph[0:3] not in area_codes:             #C
            area_codes += (ph[0:3],)              #D

    return area_codes
#A Krotka, która zawiera unikalne numery kierunkowe
#B Przechodzi przez każdy numer kierunkowy. Zmienna phones to parametr analize_friends
#C Sprawdza, czy jest tam taki sam numer kierunkowy
#D Dołącza do krotki niepowtarzalny numer kierunkowy



################
## LISTING 23.6
################
def get_states(some_areacodes):
    """
    some_areacodes, krotka z numerami kierunkowymi
    Zwraca krotkę zawierającą regiony powiązane z ich numerami kierunkowymi
    """
    states = ()
    for ac in some_areacodes:
        if ac not in all_areacodes:                  #A 
            states += ("Błędny numer kierunkowy",)
        else:
            index = all_areacodes.index(ac)          #B 
            states += (all_places[index],)           #C 
    return states
#A Użytkownik poda błędną wartość; zmienna all_areacodes to parametr analyze_friends
#B Odnajduje pozycję numeru kierunkowego w krotce
#C Używa pozycji do odnalezienia regionu 




################
## LISTING 23.7
################
def analyze_friends(names, phones, all_areacodes, all_places):
    """
    names, krotka z nazwiskami przyjaciół
    phones, krotka z numerami telefonów bez znaków specjalnych
    all_areacodes, krotka z numerami kierunkowymi w postaci ciągów
    all_places, krotka z regionami w postaci ciągów
    Wyświetla, ilu masz przyjaciół, wraz z unikalnym regionem ustalonym 
    na podstawie numeru telefonu
    """

    def get_unique_area_codes():    
        """ 
        Zwraca krotkę ze wszystkimi numerami kierunkowymi
        """
        area_codes = ()
        for ph in phones:
            if ph[0:3] not in area_codes:            
                area_codes += (ph[0:3],)

        return area_codes

    def get_states(some_areacodes):
        """
        some_area_codes, krotka z numerami kierunkowymi
        Zwraca krotkę z regionami powiązanymi z numerami kierunkowymi
        """
        states = ()
        for ac in some_areacodes:
            if ac not in all_areacodes:
                states += ("Błędny numer kierunkowy",)
            else:
                index = all_areacodes.index(ac)
                states += (all_places[index],)
        return states
    
    num_friends = len(names)                              #A 
    unique_area_codes = get_unique_area_codes()           #B 
    unique_states = get_states(unique_area_codes)         #C 
        
    print("Masz", num_friends, "przyjaciół!")             #D 
    print("Mieszkają w", unique_states)           #E

                                                  #F
#A Liczba przyjaciół
#B Zachowuje tylko unikalne numery kierunkowe
#C Pobiera regiony powiązane z unikalnymi numerami kierunkowymi
#D Wyświetla liczbę przyjaciół
#E Wyświetla unikalne regiony
#F Funkcja nie zwraca żadnej wartości


################
## LISTING 23.8
################
friends_file = open('friends.txt')                #A
(names, phones) = read_file(friends_file)         #B
areacodes_file = open('map_areacodes_states.txt') #A
(areacodes, states) = read_file(areacodes_file)   #B

clean_phones = sanitize(phones)                           #C
analyze_friends(names, clean_phones, areacodes, states)   #D

friends_file.close()                              #E
areacodes_file.close()                            #E
#A Otwiera pliki znajdujące się w tym samym folderze co program
#B Za pomocą tej samej funkcji zaczytuje różne zestawy danych
#C Normalizuje numery telefonów
#D Wywołuje funkcję, która wykonuje większość czynności
#E Zamyka pliki
