import numpy as np
from sklearn.impute import SimpleImputer
data_origin = [[30, 100],
               [20, 50],
               [35, np.nan],
               [25, 80],
               [30, 70],
               [40, 60]]

imp_mean = SimpleImputer(missing_values=np.nan, strategy='mean')
imp_mean.fit(data_origin)
data_mean_imp = imp_mean.transform(data_origin)
print(data_mean_imp)

imp_median = SimpleImputer(missing_values=np.nan, strategy='median')
imp_median.fit(data_origin)
data_median_imp = imp_median.transform(data_origin)
print(data_median_imp)

# Nowe próbki
new = [[20, np.nan],
       [30, np.nan],
       [np.nan, 70],
       [np.nan, np.nan]]
new_mean_imp = imp_mean.transform(new)
print(new_mean_imp)

# Efekt usunięcia wybrakowanych próbek i uzupełnienia wartości
from sklearn import datasets
dataset = datasets.load_diabetes()
X_full, y = dataset.data, dataset.target
m, n = X_full.shape
m_missing = int(m * 0.25)
print(m, m_missing)

np.random.seed(42)
missing_samples = np.array([True] * m_missing + [False] * (m - m_missing))
np.random.shuffle(missing_samples)
missing_features = np.random.randint(low=0, high=n, size=m_missing)
X_missing = X_full.copy()
X_missing[np.where(missing_samples)[0], missing_features] = np.nan

# Usunięcie wybrakowanych próbek
X_rm_missing = X_missing[~missing_samples, :]
y_rm_missing = y[~missing_samples]

# Wyliczenie wskaźnika R^2 po usunięciu ze zbioru wybrakowanych próbek
from sklearn.ensemble import RandomForestRegressor
from sklearn.model_selection import cross_val_score
regressor = RandomForestRegressor(random_state=42, max_depth=10, n_estimators=100)
score_rm_missing = cross_val_score(regressor, X_rm_missing, y_rm_missing).mean()
print(f'Ocena modelu po usunięciu wybrakowanych próbek: {score_rm_missing:.2f}')

# Uzupełnienie braków średnią arytmetyczną
imp_mean = SimpleImputer(missing_values=np.nan, strategy='mean')
X_mean_imp = imp_mean.fit_transform(X_missing)

# Wyliczenie wskaźnika R^2 po uzupełnieniu braków
regressor = RandomForestRegressor(random_state=42, max_depth=10, n_estimators=100)
score_mean_imp = cross_val_score(regressor, X_mean_imp, y).mean()
print(f'Ocena modelu po uzupełnieniu braków średnią arytmetyczną: {score_mean_imp:.2f}')

# Wyliczenie wskaźnika R^2 dla całego zbioru danych
regressor = RandomForestRegressor(random_state=42, max_depth=10, n_estimators=500)
score_full = cross_val_score(regressor, X_full, y).mean()
print(f'Ocena modelu dla pełnego zbioru danych: {score_full:.2f}')