import numpy as np
from sklearn.datasets import load_digits
dataset = load_digits()
X, y = dataset.data, dataset.target
print(X.shape)

# Ocena modelu dla oryginalnego zbioru danych
from sklearn.svm import SVC
from sklearn.model_selection import cross_val_score
classifier = SVC(gamma=0.005, random_state=42)
score = cross_val_score(classifier, X, y).mean()
print(f'Ocena modelu dla oryginalnego zbioru danych: {score:.2f}')

# Selekcja cech przy użyciu lasu losowego
from sklearn.ensemble import RandomForestClassifier
random_forest = RandomForestClassifier(n_estimators=100, criterion='gini', n_jobs=-1, random_state=42)
random_forest.fit(X, y)

# Sortowanie cech wg ważności
feature_sorted = np.argsort(random_forest.feature_importances_)

# Wybór różnych liczb najważniejszych cech
K = [10, 15, 25, 35, 45]
for k in K:
    top_K_features = feature_sorted[-k:]
    X_k_selected = X[:, top_K_features]
    # Ocena dokładności modelu dla k wybranych cech
    classifier = SVC(gamma=0.005)
    score_k_features = cross_val_score(classifier, X_k_selected, y).mean()
    print(f'Ocena modelu dla {k} najważniejszych cech: {score_k_features:.2f}')