import numpy as np

def sigmoid(input):
    return 1.0 / (1 + np.exp(-input))

import matplotlib.pyplot as plt
z = np.linspace(-8, 8, 1000)
y = sigmoid(z)
plt.plot(z, y)
plt.axhline(y=0, ls='dotted', color='k')
plt.axhline(y=0.5, ls='dotted', color='k')
plt.axhline(y=1, ls='dotted', color='k')
plt.yticks([0.0, 0.25, 0.5, 0.75, 1.0])
plt.xlabel('z')
plt.ylabel('y(z)')
plt.show()

y_hat = np.linspace(0, 1, 1000)
cost = -np.log(y_hat)
plt.plot(y_hat, cost)
plt.xlabel('Prognoza')
plt.ylabel('Koszt')
plt.xlim(0, 1)
plt.ylim(0, 7)
plt.show()

y_hat = np.linspace(0, 1, 1000)
cost = -np.log(1 - y_hat)
plt.plot(y_hat, cost)
plt.xlabel('Prognoza')
plt.ylabel('Koszt')
plt.xlim(0, 1)
plt.ylim(0, 7)
plt.show()