from flask import Flask, session, render_template, request

import os
import narzedzia_konwersji
import narzedzia_danych 


app = Flask(__name__)
app.secret_key = "Nigdy mnie nie odgadniesz..."


@app.get("/")
def index():
    return render_template(
        "index.html",
        title="Witamy na stronie klubu pływackiego",
    )


@app.get("/treningi")
def display_swim_sessions():
    data = narzedzia_danych.get_swim_sessions()
    dates = [session[0].split(" ")[0] for session in data] 
    return render_template(
        "select.html",
        title="Wybierz datę treningu",
        url="/plywacy",
        select_id="chosen_date",
        select_text="datę treningu",
        data=dates,
    ) 


@app.post("/plywacy")
def display_swimmers():
    session["chosen_date"] = request.form["chosen_date"]
    data = narzedzia_danych.get_session_swimmers(session["chosen_date"])
    swimmers = [f"{swimmer[0]}-{swimmer[1]}" for swimmer in data]
    return render_template(
        "select.html",
        title="Wybierz pływaka",
        url="/pokazkonkurencje",
        select_id="swimmer",
        select_text="pływaka",
        data=sorted(swimmers),
    )


@app.post("/pokazkonkurencje")
def display_swimmer_events():
    session["swimmer"], session["age"] = request.form["swimmer"].split("-")
    data = narzedzia_danych.get_swimmers_events(
        session["swimmer"], session["age"], session["chosen_date"]
    )
    events = [f"{event[0]} {event[1]}" for event in data]
    return render_template(
        "select.html",
        title="Wybierz konkurencję",
        url="/pokazwykres",
        select_id="event",
        select_text="konkurencję",
        data=events,
    )


@app.post("/pokazwykres")
def show_bar_chart():
    distance, stroke = request.form["event"].split(" ")
    data = narzedzia_danych.get_swimmers_times(
        session["swimmer"],
        session["age"],
        distance,
        stroke,
        session["chosen_date"],
    )
    times = [time[0] for time in data]
    average_str, times_reversed, scaled = narzedzia_konwersji.perform_conversions(times)
    world_records = narzedzia_konwersji.get_worlds(distance, stroke)
    header = f"{session['swimmer']} (poniżej {session['age']} lat), {distance}, styl: {stroke} - {session['chosen_date']}"
    return render_template(
        "chart.html",
        title=header,
        data=list(zip(times_reversed, scaled)),
        average=average_str,
        worlds=world_records,
    )


if __name__ == "__main__":
    app.run(debug=True)
