import csv
import dateutil

import pylab as py
import matplotlib.dates as mdates

if __name__ == "__main__":
    data = list(csv.DictReader(open("processor.csv")))
    dates = [dateutil.parser.parse(x['date']) for x in data if x['date']]
    clock = [x['clock'] for x in data if x['date']]

    ax = py.gca()
    fig = py.gcf()

    ax.scatter(mdates.date2num(dates), clock, alpha=0.5)
    ax.set_xticklabels([d.strftime("%Y") for d in mdates.num2date(
        ax.get_xticks())], rotation=15, ha='right')
    ax.set_yscale('log')

    ax.set_ylabel("Szybkość zegara (MHz)")
    ax.set_xlabel("Data wprowadzenia procesora")
    ax.set_title("Historyczny wzrost szybkości zegara procesora")

    py.savefig("images/processor_clock.png")
    py.show()
