import fnmatch
import itertools
import codecs
import os
import glob

# Konwersja plików Wikipedia na listę unikalnych wyrazów.
# Oczywiście ten plik nie zmieści się w pamięci RAM...

matches = []
WIKIPEDIA_RAW_DIR = "/media/ian/data/wikipedia_data_dump/extracted/"
# ["/media/ian/data/wikipedia_data_dump/extracted/AA", "/media/ian/data/wikipedia_data_dump/extracted/AB"] 
WIKIPEDIA_FILES_ROOTS = glob.glob(os.path.join(
    WIKIPEDIA_RAW_DIR, "A*")) + glob.glob(os.path.join(WIKIPEDIA_RAW_DIR, "B*"))
print "Przetwarzanie z nieprzetworzonych elementów głównych:", WIKIPEDIA_FILES_ROOTS
for wikipedia_files_root in WIKIPEDIA_FILES_ROOTS:
    for root, dirnames, filenames in os.walk(wikipedia_files_root):
        for filename in fnmatch.filter(filenames, 'wiki*'):
            matches.append(os.path.join(root, filename))
SUMMARISED_FILE = "all_unique_words_wikipedia_AABZ.txt"
LONG_FILES = matches
print "Użycie (np. {} z {})".format(len(LONG_FILES), LONG_FILES[:10])


def read_words(filename):
    # Zwraca wyrazy z pliku za pomocą generatora
    try:
        with codecs.open(filename, 'r', 'utf-8') as f:
            for line_nbr, line in enumerate(f):
                items = line.strip().split()
                for item in items:
                    yield item
    except UnicodeDecodeError:
        print "Błąd UnicodeDecodeError dla {} w pobliżu wiersza {} i wyrazu {}".format(filename, line_nbr, line)

readers = itertools.chain(*(read_words(lf) for lf in LONG_FILES))

if __name__ == "__main__":
    words_set = set(readers)
    print "Zebranie plików wejściowych w jednym zbiorze wyjściowym {} wyrazów.".format(len(words_set))
    with codecs.open(SUMMARISED_FILE, 'w', 'utf-8') as f:
        for word in words_set:
            f.write(word + "\n")
