import math
import time
import cPickle
import argparse
import matplotlib.pyplot as plt
import numpy as np


def check_prime(N):
    sqrtN = math.sqrt(N)
    Nf = float(N)
    for i in xrange(2, int(sqrtN) + 1):
        if (Nf / i).is_integer():
            return False
    return True


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description='Opis projektu')
    parser.add_argument(
        '--create_data',
        action="store_true",
        default=False,
        help='Jeśli istnieje, nastąpi obliczenie dla danych. W przeciwnym razie zostanie wygenerowany wykres.')
    args = parser.parse_args()
    filename = "08_prime_time_cost_1e4to1e6.pickle"

    if args.create_data:
        primes = []
        are_primes = []
        times = []
        # objaśnienie
        #lower_range = 3
        #upper_range = 1000
        # odpowiedni zakres
        lower_range = 10001
        upper_range = 1000000
        numbers_to_test = np.array(range(lower_range, upper_range, 10))
        for possible_prime in numbers_to_test:
            min_time = 9999
            # Przeprowadzenie kilkakrotnych obliczeń w celu zarejestrowania najkrótszego czasu
            for loop in xrange(20):
                t1 = time.time()
                is_prime = check_prime(possible_prime)
                t2 = time.time()
                min_time = min(t2 - t1, min_time)
            times.append(min_time)
            # Konieczne jest tylko jednokrotne dodanie wyniku
            if is_prime:
                primes.append(possible_prime)
            are_primes.append(is_prime)
        print primes[:10], primes[-10:]
        are_primes = np.array(are_primes)
        times = np.array(times)
        cPickle.dump(
            (numbers_to_test, are_primes, times), open(filename, 'wb'))
    else:
        numbers_to_test, are_primes, times = cPickle.load(open(filename))
        # Trzykrotne generowanie wykresu dla dwóch elementów. Ostatni z wykresów nie ma etykiety (ale prezentuje 
        # wynik z liczbą inną niż pierwsza), dlatego elementy legendy są
        # wyświetlane w poprawnej kolejności
        plt.plot(numbers_to_test[are_primes], times[
                 are_primes], 'x', color='k', alpha=1, label="Prime")
        plt.plot(
            numbers_to_test[
                are_primes == False],
            times[
                are_primes == False],
            '.',
            color='b',
            alpha=0.6,
            label="Liczba inna niż pierwsza")
        plt.plot(numbers_to_test[are_primes], times[
                 are_primes], 'x', color='k', alpha=1, )
        plt.xlabel("Liczby całkowite do testowania")
        plt.ylabel("Liczba sekund przypadająca na test")
        plt.title("Czas sprawdzania liczb pierwszych")
        plt.ylim(0, 0.00015)  # Odpowiednie dla laptopa Iana
        # plt.grid()
        plt.legend()
        plt.savefig("08_prime_time_cost_1e4to1e6.png")
        plt.tight_layout()
        # plt.show()
