import time
import timeit
import text_example
import memory_profiler
import marisa_trie

if __name__ == "__main__":
    print "Zajęta pamięć RAM przy uruchamianiu: {:0.1f} MiB".format(memory_profiler.memory_usage()[0])
    # Unikaj budowania tymczasowej listy słów za pomocą kodu Python. Listę przechowuj bezpośrednio w
    # drzewie trie.
    t1 = time.time()
    words_trie = marisa_trie.Trie(text_example.readers)
    t2 = time.time()
    print "Zużycie pamięci RAM po utworzeniu drzewa trie: {:0.1f} MiB. Czas trwania: {:0.1f} s.".format(memory_profiler.memory_usage()[0], t2 - t1)
    print "Drzewo trie  zawiera {} słów.".format(len(words_trie))

    assert u'Zwiebel' in words_trie
    time_cost = sum(timeit.repeat(stmt="u'Zwiebel' in words_trie",
                                  setup="from __main__ import words_trie",
                                  number=1,
                                  repeat=10000))
    print "Łączny czas wyszukiwania słowa: {:0.4f} s".format(time_cost)
