"""Wykres - czas wykonywania dla wariantów przybliżenia liczby Pi za pomocą narzędzia numpy opartych na wykonywaniu szeregowym, wątkach i procesach"""
import numpy as np
import matplotlib.pyplot as plt

# Czasy wygenerowane za pomocą funkcji
# pi_numpy_serial_blocks.py
# (serial.py - tak samo jak dla bloków szeregowych, ale tylko dla jednej dużej tablicy)
# pi_numpy_parallel_worker.py
speeds = np.array([[6.4, 6.4, 6.4, 6.4],
                   [6.4, 5.6, 5.3, 5.1],
                   [6.4, 3.2, 1.7, 1.5]])

nbr_cores = np.array([[1, 1, 1, 1],
                      [1, 2, 4, 8],
                      [1, 2, 4, 8]])

labels = np.array(["Wykonywanie szeregowe", "Wątki", "Procesy"])

plt.figure(1)
plt.clf()
markers = ['-.x', '--x', '-x']
for nc, sp, label, mk in zip(nbr_cores, speeds, labels, markers):
    plt.plot(nc, sp, mk, label=label, linewidth=2)
plt.legend(loc="lower left", framealpha=0.8)
plt.ylim(1, 7)
plt.xlim(0.5, 8.5)
plt.ylabel("Czas wykonywania (sekundy) – im krótszy, tym lepiej")
plt.xlabel("Liczba procesów roboczych")
plt.title(
    "Czas przybliżenia liczby Pi za pomocą obiektów z 100 000 000\nrzutek w przypadku wykonywania szeregowego, wątków i procesów")
# plt.grid()
# plt.show()
plt.tight_layout()
plt.savefig("08_pi_numpy_graph_speed_tests_threaded_processes.png")
