def calculate_z(maxiter, zs, cs):
    """Obliczanie listy output przy użyciu reguły aktualizacji zbioru Julii"""
    output = [0] * len(zs)
    for i in range(len(zs)):
        n = 0
        z = zs[i]
        c = cs[i]
        while n < maxiter and abs(z) < 2:
            z = z * z + c
            n += 1
        output[i] = n
    return output


if __name__ == "__main__":
    # Tworzenie trywialnego przykładu za pomocą poprawnych typów w celu umożliwienia 
    # wywołania funkcji przez inferencję typów, aby kompilator Shed Skin mógł analizować typy.
    output = calculate_z(1, [0j], [0j])
