import csv

import dateutil
import matplotlib.dates as mdates
import pylab as py

if __name__ == "__main__":
    data = list(csv.DictReader(open("processor.csv")))
    dates = [dateutil.parser.parse(x["date"]) for x in data if x["date"]]
    clock = [x["clock"] for x in data if x["date"]]

    ax = py.gca()
    fig = py.gcf()

    ax.scatter(mdates.date2num(dates), clock, alpha=0.5)
    ax.set_xticklabels(
        [d.strftime("%Y") for d in mdates.num2date(ax.get_xticks())],
        rotation=15,
        ha="right",
    )
    ax.set_yscale("log")

    ax.set_ylabel("Szybkość zegara (MHz)")
    ax.set_xlabel("Data udostępnienia procesora")
    ax.set_title("Historyczny wzrost szybkości zegara procesora")

    py.savefig("../processor_clock.png")
