#!/usr/bin/env python
# -*- coding: utf8 -*-

import os
from xml.dom import minidom

def test_html_report(testpath):
    print """
    ================================
    TWORZENIE RAPORTU HTML
    ================================
    """
    prompt = """
    Wprowadź datę wywołania testu
    w formacie '01-01-2008'
    """
    test_date = raw_input (prompt)
    
    test_run_file = testpath + test_date + ".xml"
    
    # Odczyt węzłów z pliku XML
    try:
        test_run = minidom.parse(test_run_file)
    except:
        print "\n\tBłąd otwarcia wyników wywołania!\n"
        raw_input("Naciśnij [Enter]:  ")
        return
    test_result_node = test_run.childNodes[0]
    test_firstname_node = test_result_node.childNodes[1]
    test_lastname_node = test_result_node.childNodes[3]
    test_prime_node = test_result_node.childNodes[5]
    test_passed_node = test_result_node.childNodes[7]
    test_failed_node = test_result_node.childNodes[9]
    test_error_node = test_result_node.childNodes[11]
    
    # Odczyt tekstu z odpowiednich węzłów
    test_firstname_result = test_firstname_node.firstChild.data
    test_lastname_result = test_lastname_node.firstChild.data
    test_prime_result = test_prime_node.firstChild.data
    test_passed_result = test_passed_node.firstChild.data
    test_failed_result = test_failed_node.firstChild.data
    test_error_result = test_error_node.firstChild.data
    
    # Zapis wyniku do pliku XTML
    html_output = u"""
    <HTML>
    <TITLE>Raport z testów - %s</TITLE>
    <HR>
    <H1>WYNIKI WYWOŁANIA TESTÓW %s</H1>
    <HR>
    <BODY>
    Test imienia - %s<br>
    Test nazwiska - %s<br>
    Test liczby pierwszej - %s<br>
    <HR>
    Liczba testów zakończonych powodzeniem:  %s<br>
    Liczba testów zakończonych niepowodzeniem:  %s<br>
    Liczba testów zakończoncyh błędem:  %s<br>
    </BODY>
    </HTML>
    """ % (test_date, test_date, test_firstname_result, test_lastname_result, \
    test_prime_result, test_passed_result, test_failed_result, test_error_result)
    
    filename = os.path.join(os.curdir, 'test_report_html', test_date + ".html")
    output_file = open(filename, 'w')
    output_file.write(html_output.encode('utf8'))
    output_file.close()
    
    print "\n\t-- Zakończono generowanie raportu HTML --"
    raw_input("\tNaciśnij [Enter]:  ")
    

    
