# -*- coding: utf-8 -*-

import os, pickle, difflib, sys, pprint

def createSnapshot(directory, filename):    
    cumulative_directories = []
    cumulative_files = []

    for root, dirs, files in os.walk(directory):
        cumulative_directories = cumulative_directories + dirs
        cumulative_files = cumulative_files + files
        
    try:
        output = open(filename, 'wb')
        pickle.dump(cumulative_directories, output, -1)
        pickle.dump(cumulative_files, output, -1)
        output.close()
    except:
        print "Wystąpiły problemy przy zapisie pliku migawki!"
    
    raw_input("\n\nNaciśnij [Enter]...")
    return

def listSnapshots(extension):
    snaplist = []
    filelist = os.listdir(os.curdir)
    for item in filelist:
        if item.find(extension)!= -1:
            snaplist.append(item)

    print '''
    Lista migawek:
    ========================
    '''
    printlist(snaplist)
    
    raw_input("\n\nNaciśnij [Enter]...")
    

def compareSnapshots(snapfile1, snapfile2):

    try:
        pkl_file = open(snapfile1, 'rb')
        dirs1 = pickle.load(pkl_file)
        files1 = pickle.load(pkl_file)
        pkl_file.close()

        pk2_file = open(snapfile2, 'rb')
        dirs2 = pickle.load(pk2_file)
        files2 = pickle.load(pk2_file)
        pk2_file.close()
    except:
        print "Wystąpiły problemy przy odczycie plików migawek!"
    raw_input("\n\nNaciśnij [Enter]...")
    return

    result_dirs = list(difflib.unified_diff(dirs1, dirs2))
    result_files = list(difflib.unified_diff(files1, files2))

    added_dirs = []
    removed_dirs = []
    added_files = []
    removed_files = []
    
    for result in result_files:
        if result.find("\n") == -1:
            if result[0] == "+":
                resultadd = result.strip('+')
                added_files.append(resultadd)
            elif result[0] == "-":
                resultsubtract = result.strip('-')
                removed_files.append(resultsubtract)

    for result in result_dirs:
        if result.find("\n") == -1:
            if result[0] == "+":
                resultadd = result.strip('+')
                added_dirs.append(resultadd)
            elif result[0] == "-":
                resultsubtract = result.strip('-')
                removed_dirs.append(resultsubtract)
                
    print "\n\nDodane katalogi:\n"
    printList(added_dirs)
    print "\n\nDodane pliki:\n"
    printList(added_files)
    print "\n\nUsunięte katalogi:\n"
    printList(removed_dirs)
    print "\n\nUsunięte pliki:\n"
    printList(removed_files)
    raw_input("\n\nNaciśnij [Enter]...")

def showHelp():
    os.system('cls')
    print '''
    NARZĘDZIE DO WYKONYWANIA MIGAWEK KATALOGÓW I PLIKÓW
    ====================================
    Ten program służy do tworzenia migawek drzew plików i katalogów,
    wyświetlania listy utworzonych migawek zapisanych w bieżącym katalogu i
    porównywania dwóch migawek w celu zapoznania się z plikami i katalogami
    dodanymi lub usuniętymi w okresie między wykonaniiem pierwszej i drugiej
    migawki.
    
    Z menu programu można wywołać następujące operacje:
    1.  Utwórz migawkę
    2.  Wypisz pliki migawki
    3.  Porównaj migawki
    4.  Pomoc (niniejszy ekran)
    5.  Koniec
    
    '''
    raw_input("\n\nNaciśnij [Enter]...")

def invalidChoice():
    sys.stderr.write("NIEPRAWIDŁOWA OPCJA, SPRÓBUJ PONOWNIE!")
    raw_input("\n\nNaciśnij [Enter]...")
    
    
def printList(list):
    fulllist = ""
    indexnum = 1
    
    if len(list) > 20:
        for item in list:
            print "\t\t" + item,
            if (indexnum)%3 == 0:
                print "\n"
            indexnum = indexnum + 1
    else:
        for item in list:
            print "\t" + item
