#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
import check_versions, csv_report

HOST = sys.argv[1]
USER = "jars"
PASSWORD = "jars"

def check_arguments():
    if len(sys.argv) < 3:
        print """ Niewystarczające argumenty:  sugerowane wywołanie -
        python version_checker.py <adres ip> "<aplikacje>"
        
        Uwagi:
        1.  W miejsce <adres ip> należy wpisać adres IP komputera do sprawdzenia.
        2.  W miejsce <aplikacje> należy wpisać kody aplikacji wybrane
        z poniższej listy (w cudzysłowach, oddzielone spacjami):
                java
                python
                perl
                
        Przykład:
        
        python version_checker.py 1.1.1.1 "python java"
        
        To wyhwołanie spowoduje sprawdzenie wersji środowisk języków Python i
        Java na komputerze o adresie 1.1.1.1."""
        sys.exit(1)
    

def get_versions():
    print "HOST - ", HOST
    if "java" in sys.argv[2]:
        java_version = check_versions.check_java(HOST, USER, PASSWORD)
        csv_report.write_csv_log(HOST, "Java", java_version)
        print "Wersja Javy = ", java_version
    if "python" in sys.argv[2]:
        python_version = check_versions.check_python(HOST, USER, PASSWORD)
        csv_report.write_csv_log(HOST, "Python", python_version)
        print "Wersja Pythona = ", python_version
    if "perl" in sys.argv[2]:
        perl_version = check_versions.check_perl(HOST, USER, PASSWORD)
        csv_report.write_csv_log(HOST, "Perl", perl_version)
        print "Wersja Perla = ", perl_version

check_arguments()
get_versions()

