﻿# Rozdział 15. Głębokie uczenie
## 15.9. Rekurencyjne sieci neuronowe i ciągi danych: analiza sentymentu w zbiorze „IMDb”
### 15.9.1. Wczytywanie zbioru „IMDb” 
from tensorflow.keras.datasets import imdb
number_of_words = 10000
(X_train, y_train), (X_test, y_test) = imdb.load_data(
             num_words=number_of_words)

### 15.9.2. Eksploracja danych
X_train.shape
y_train.shape
X_test.shape
y_test.shape
%pprint
X_train[123]

#### 15.9.2.2. Dekodowanie recenzji
word_to_index = imdb.get_word_index()
word_to_index['great']
index_to_word = \
    {index: word for (word, index) in word_to_index.items()}

[index_to_word[i] for i in range(1, 51)]

' '.join([index_to_word.get(i - 3, '?') for i in X_train[123]])

y_train[123]

### 15.9.3. Preparacja danych
words_per_review = 200    # maksymalna liczba słów w recenzji
from tensorflow.keras.preprocessing.sequence import pad_sequences
X_train = pad_sequences(X_train, maxlen=words_per_review)
X_train.shape
X_test = pad_sequences(X_test, maxlen=words_per_review)
X_test.shape

#### 15.9.3.1. Wydzielenie próbek walidacyjnych
from sklearn.model_selection import train_test_split
X_test, X_val, y_test, y_val = train_test_split(
    X_test, y_test, random_state=11, test_size=0.20)

X_test.shape

X_val.shape

### 15.9.4. Budowanie sieci neuronowej
from tensorflow.keras.models import Sequential
rnn = Sequential()

from tensorflow.keras.layers import Dense, LSTM
from tensorflow.keras.layers.embeddings import Embedding

#### 15.9.4.1. Dodawanie warstwy osadzania
rnn.add(Embedding(input_dim=number_of_words, output_dim=128,
                        input_length=words_per_review))

#### 15.9.4.2. Dodawanie warstwy LSTM
rnn.add(LSTM(units=128, dropout=0.2, recurrent_dropout=0.2))

#### 15.9.4.3. Dodawanie końcowej warstwy gęstej
rnn.add(Dense(units=1, activation='sigmoid'))

#### 15.9.4.4. Kompilowanie modelu i wypisywanie podsumowania
rnn.compile(optimizer='adam',
            loss='binary_crossentropy',
            metrics=['accuracy'])

rnn.summary()

rnn.fit(X_train, y_train, epochs=10, batch_size=32,
        validation_data=(X_test, y_test))

results = rnn.evaluate(X_test, y_test)
results
