﻿## 10.8. Hierarchia dziedziczenia a polimorfizm
#### 10.8.1.1. Uniwersalna klasa bazowa „object”
x = object()
x
repr(x)

#### 10.8.1.2. Klasa „Akwizytor” w akcji
from akwizytor import Akwizytor
from decimal import Decimal

c = Akwizytor('Sue', 'Jones', '333-33-3333',
              Decimal('10000.00'), Decimal('6'))
c

print(f'{c.zarobek():,.2f}')

c.sprzedaz = Decimal('20000.00')
c.prowizja = Decimal('10')
print(f'{c.zarobek():,.2f}')


#### 10.8.2.6. Klasa „AkwizytorNaEtacie” w akcji
from akwizytornaetacie import AkwizytorNaEtacie
s = AkwizytorNaEtacie('Bob', 'Lewis', '444-44-4444',
                      Decimal('5000.00'), Decimal('4'), Decimal('300.00'))    

print(s.imie, s.nazwisko, s.nr_ubezpieczenia, s.sprzedaz,
      str(s.prowizja)+'%', s.pensja)

--------------------------------
print(f'{s.zarobek():,.2f}')
--------------------------------
s.sprzedaz = Decimal('10000.00')
s.prowizja = Decimal('5')
s.pensja = Decimal('1000.00')
print(s)
--------------------------------
print(f'{s.zarobek():,.2f}')

#### 10.8.2.7. Testowanie relacji „jest” 
issubclass(AkwizytorNaEtacie, Akwizytor)
issubclass(AkwizytorNaEtacie, AkwizytorNaEtacie)
isinstance(s, AkwizytorNaEtacie)
isinstance(s, Akwizytor)

### 10.8.3. Polimorficzne przetwarzanie obiektów
pracownicy = [c, s]

for pracownik in pracownicy:
    print(pracownik)
    print(f'{pracownik.zarobek():,.2f}\n')   
