# RollDieDynamic.py
#-*- coding: 1250 -*-
"""Dynamicznie uaktualniany wykres statystyki rzutw kostk."""

from matplotlib import animation
import matplotlib.pyplot as plt
import random 
import seaborn as sns
import sys

def polski_integer(liczba):
    """Spacja, nie przecinek w roli separatora tysicy"""
    return f'{liczba:,}'.replace(',', ' ')
    
def polski_float(liczba):
    """Przecinek dziesitny zamiast kropki"""
    return f'{liczba:.3f}'.replace('.', ' ')
    
def nowa_ramka(nr_ramki, rzuty_w_ramce, liczby_oczek, statystyka_oczek):
    """Konfiguracja zawartoci wykresu dla kadej ramki animacji"""
    
    # symulacja nastpnej porcji rzutw
    for i in range(rzuty_w_ramce):
        statystyka_oczek[random.randrange(1, 7) - 1] += 1 

    # rekonfiguracja wykresu dla uaktualnionej statystyki rzutw
    plt.cla()  # wyczyszczenie dotychczasowej zawartoci wykresu
    seria_str = polski_integer(sum(statystyka_oczek))
    
    nazwa_wykresu = (
        'Czstotliwoci wystpie liczb oczek po wykonaniu'
        f' {seria_str} rzutw'
    )
     
    # nowe supki
    osie = sns.barplot(liczby_oczek, statystyka_oczek, palette='bright')  
 
    # tytu wykresu
    osie.set_title(nazwa_wykresu)
 
    # etykiety osi
    osie.set(xlabel='Liczba oczek', ylabel='Czstotliwo')
    
    # przeskalowanie osi o 10% w stosunku do wymaganej dugoci
    osie.set_ylim(top=max(statystyka_oczek) * 1.10)  

    # wypisanie liczby wystpie (bezwzgldnej i procentowej)
    # nad kadym supkiem
    for pasek, ile_razy_liczba_oczek in zip(osie.patches, statystyka_oczek):
        tekst_x = pasek.get_x() + pasek.get_width() / 2.0  
        tekst_y = pasek.get_height() 
        ile_razy_liczba_oczek_str = polski_integer(ile_razy_liczba_oczek)
        
        ile_procent_liczba_oczek = \
           100.0 * (ile_razy_liczba_oczek / sum(statystyka_oczek)) 
        
        ile_procent_liczba_oczek_str = polski_float(ile_procent_liczba_oczek) + '%'
        tekst = ile_razy_liczba_oczek_str + '\n' + ile_procent_liczba_oczek_str 
        osie.text(tekst_x, tekst_y, tekst, ha='center', va='bottom')



# sprawdzenie i odczyt parametrw wiersza polece
if len(sys.argv) < 3:
   print('Uruchamianie:')
   print('  ' + sys.argv[0] + ' <ramki>  <rzuty>')
   print()
   print('gdzie:')
   print('  <ramki> - liczba ramek w animacji')
   print('  <rzuty> - liczba rzutw w kadej ramce')
   print()
   sys.exit()

liczba_ramek = int(sys.argv[1])  
rzuty_w_jednej_ramce = int(sys.argv[2])  

sns.set_style('whitegrid')  # biae to z jasnoszar siatk
obiekt_okna = plt.figure('Symulacja serii rzutw szecienn kostk') 
etykiety_1_do_6 = list(range(1, 7))  # liczby oczek na osi x
liczniki_oczek = [0] * 6  # liczniki wystpie liczb oczek

# skonfigurowanie i uruchomienie animacji

animacja = animation.FuncAnimation(
    obiekt_okna, nowa_ramka, repeat=False, frames=liczba_ramek, interval=33,
    fargs=(rzuty_w_jednej_ramce, etykiety_1_do_6, liczniki_oczek))

plt.show()  # wywietlenie okna


#**************************************************************************
#* (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
#* Pearson Education, Inc. All Rights Reserved.                           *
#*                                                                        *
#* DISCLAIMER: The authors and publisher of this book have used their     *
#* best efforts in preparing the book. These efforts include the          *
#* development, research, and testing of the theories and programs        *
#* to determine their effectiveness. The authors and publisher make       *
#* no warranty of any kind, expressed or implied, with regard to these    *
#* programs or to the documentation contained in these books. The authors *
#* and publisher shall not be liable in any event for incidental or       *
#* consequential damages in connection with, or arising out of, the       *
#* furnishing, performance, or use of these programs.                     *
#**************************************************************************
