﻿# Rozdział 12. Eksploracja masowych danych — Twitter
## 12.6. Biblioteka „Tweepy”
### 12.6.1. Instalowanie bibliotek „Tweepy” i „Geopy ”
pip install tweepy==3.7
conda install -c conda-forge geopy

## 12.7. Uwierzytelnianie za pomocą biblioteki „Tweepy” 
import tweepy
import keys

### 12.7.1. Obiekt uwierzytelniający „OAuthHandler”
auth = tweepy.OAuthHandler(
           keys.consumer_key, keys.consumer_secret)

auth.set_access_token(
           keys.access_token, keys.access_token_secret)

### 12.7.2. Obiekt API — interakcja z API Twittera
api = tweepy.API(
                 auth, wait_on_rate_limit=True, 
                 wait_on_rate_limit_notify=True)  

## 12.8. Informacja o koncie Twittera
nasa = api.get_user('nasa')

### 12.8.1. Podstawowe parametry
nasa.id
nasa.name
nasa.screen_name
nasa.description

### 12.8.2. Ostatnio wysłany tweet
nasa.status.text

### 12.8.3. Obserwujący
nasa.followers_count

### 12.8.4. Znajomi
nasa.friends_count

### 12.8.5. Informacje o sobie
moje_konto = api.me()

## 12.9. Kursory biblioteki „Tweepy”
### 12.9.1. Lista obserwujących
obserwatorzy = []

#### 12.9.1.1. Tworzenie kursora
cursor = tweepy.Cursor(api.followers, screen_name='nasa')

#### 12.9.1.2. Pobieranie wyników
for konto in cursor.items(10):                 
    obserwatorzy.append(konto.screen_name)

print('Obserwatorzy:',
      ' '.join(sorted(obserwatorzy, key=lambda s: s.lower())))


### 12.9.2. Informacje o znajomych
znajomi = []
cursor = tweepy.Cursor(api.friends, screen_name='nasa')
for znajomy in cursor.items(10):
    znajomi.append(znajomy.screen_name)

print('Znajomi:',
      ' '.join(sorted(znajomi, key=lambda s: s.lower())))

### 12.9.3. Najnowsze tweety z konta
nasa_tweets = api.user_timeline(screen_name='nasa', count=3)

for tweet in nasa_tweets:
    print(f'{tweet.user.screen_name}: {tweet.text}\n')
    
#### 12.9.3.1. Moje najnowsze tweety
moje_tweety = api.home_timeline()
moje_tweety

## 12.10. Przeszukiwanie niedawnych tweetów
### 12.10.1. Funkcja użytkowa „print_tweets” 
from tweetutilities import print_tweets
       
### 12.10.2. Wyszukiwanie określonych słów
tweets = api.search(q='Mars Opportunity Rover', count=3)
print_tweets(tweets)

### 12.10.3. Operatory wyszukiwania
tweets = api.search(q='from:nasa since:2020-02-01', count=3)
print_tweets(tweets)

#### 12.10.3.1. Wyszukiwanie hashtagów
tweets = api.search(q='#collegefootball', count=2)
print_tweets(tweets)

## 12.11. Odkrywanie trendów — Twitter Trends API
### 12.11.1. Umiejscawianie trendów
trends_available = api.trends_available()
len(trends_available)
trends_available[0]
trends_available[1]

#### 12.11.2.1. Trendy światowe
world_trends = api.trends_place(id=1)
trends_list = world_trends[0]['trends']
trends_list[0]
trends_list = [t for t in trends_list if t['tweet_volume']]

from operator import itemgetter
trends_list.sort(key=itemgetter('tweet_volume'), reverse=True)

for trend in trends_list[:5]:
    print(trend['name'])

#### 12.11.2.2. Trendy lokalne — Nowy Jork  
nyc_trends = api.trends_place(id=2459115) # WOEID Nowego Jorku WOEID
nyc_list = nyc_trends[0]['trends']
nyc_list = [t for t in nyc_list if t['tweet_volume']]
nyc_list.sort(key=itemgetter('tweet_volume'), reverse=True)

for trend in nyc_list[:5]:
    print(trend['name'])

### 12.11.3. Tworzenie chmury słów na podstawie listy trendów
topics = {}

for trend in nyc_list:
    topics[trend['name']] = trend['tweet_volume']

from wordcloud import WordCloud

wordcloud = WordCloud(width=1600, height=900,
              prefer_horizontal=0.5, min_font_size=10, colormap='prism',
              background_color='white')

wordcloud = wordcloud.fit_words(topics)

wordcloud = wordcloud.to_file('TrendingTwitter.png')

%matplotlib

import matplotlib.pyplot as plt
plt.imshow(wordcloud)
