﻿# talia.py


# (C) Copyright 2019 by Deitel & Associates, Inc. and                    #
# Pearson Education, Inc. All Rights Reserved.                           #
# Revised by A.Grażyński, (C) Copyright 2020 by Helion Publishing


"""Klasa reprezentująca talię kart do gry."""
import random 
from karta_dataclass import Karta

class TaliaKart:
    LICZBA_KART = 52  # ustalona liczba kart

    def __init__(self):
        """Inicjowanie talii."""
        self._current_card = 0
        self._deck = []

        for count in range(TaliaKart.LICZBA_KART):  
            self._deck.append(Karta(Karta.FACES[count % 13], 
                Karta.SUITS[count // 13]))

    def tasuj(self):
        """Tasowanie talii."""
        self._current_card = 0
        random.shuffle(self._deck)    

    def kolejna_karta_z_talii(self):
        """Rozdawanie - zwraca pojedynczą kartę."""
        try:
            karta = self._deck[self._current_card]
            self._current_card += 1
            return karta
        except:
            return None  

    def __str__(self):
        """Zwraca tekstową reprezentację talii."""
        save_current_card_nr = self._current_card
        s = ''

        for indeks, karta in enumerate(self._deck):
            s += f'{self.kolejna_karta_z_talii():<19}'
            if (indeks + 1) % 4 == 0:
                s += '\n'
        self._current_card = save_current_card_nr 
        return s


##########################################################################
# (C) Copyright 2019 by Deitel & Associates, Inc. and                    #
# Pearson Education, Inc. All Rights Reserved.                           #
#                                                                        #
# DISCLAIMER: The authors and publisher of this book have used their     #
# best efforts in preparing the book. These efforts include the          #
# development, research, and testing of the theories and programs        #
# to determine their effectiveness. The authors and publisher make       #
# no warranty of any kind, expressed or implied, with regard to these    #
# programs or to the documentation contained in these books. The authors #
# and publisher shall not be liable in any event for incidental or       #
# consequential damages in connection with, or arising out of, the       #
# furnishing, performance, or use of these programs.                     #
##########################################################################
