﻿# timewithproperties.py

"""Klasa Time z właściwościami do odczytu i zapisu."""

class Time:
    """Klasa Time z właściwościami do odczytu i zapisu."""

    def __init__(self, hour=0, minute=0, second=0):
        """Inicjowanie atrybutów."""
        self.hour = hour  # 0-23
        self.minute = minute  # 0-59
        self.second = second  # 0-59

    @property
    def hour(self):
        """Zwraca wskazanie godzin."""
        return self._hour

    @hour.setter
    def hour(self, hour):
        """Ustawia wskazanie godzin."""
        if not (0 <= hour < 24):
            raise ValueError(f'Godziny ({hour}) poza przedziałem 0-23')

        self._hour = hour

    @property
    def minute(self):
        """Zwraca wskazanie minut."""
        return self._minute

    @minute.setter
    def minute(self, minute):
        """Ustawia wskazanie minut."""
        if not (0 <= minute < 60):
            raise ValueError(f'Minuty ({minute})  poza przedziałem  0-59')

        self._minute = minute

    @property
    def second(self):
        """Zwraca wskazanie sekund."""
        return self._second

    @second.setter
    def second(self, second):
        """Ustawia wskazanie sekund."""
        if not (0 <= second < 60):
            raise ValueError(f'Sekundy ({second}) poza przedziałem 0-59')

        self._second = second

    def set_time(self, hour=0, minute=0, second=0):
        """Ustawia wskazania godzin, minut i sekund."""
        self.hour = hour
        self.minute = minute
        self.second = second

    def __repr__(self):
        """Zwraca reprezentację tekstową wg repr()."""
        return (f'Time(hour={self.hour}, minute={self.minute}, ' + 
                f'second={self.second})')

    def __str__(self):
        """Zwraca wskazanie czasu w formacie 12-godzinnym."""
        return (('12' if self.hour in (0, 12) else str(self.hour % 12)) + 
                f':{self.minute:0>2}:{self.second:0>2}' + 
                (' AM' if self.hour < 12 else ' PM'))


##########################################################################
# (C) Copyright 2019 by Deitel & Associates, Inc. and                    #
# Pearson Education, Inc. All Rights Reserved.                           #
#                                                                        #
# DISCLAIMER: The authors and publisher of this book have used their     #
# best efforts in preparing the book. These efforts include the          #
# development, research, and testing of the theories and programs        #
# to determine their effectiveness. The authors and publisher make       #
# no warranty of any kind, expressed or implied, with regard to these    #
# programs or to the documentation contained in these books. The authors #
# and publisher shall not be liable in any event for incidental or       #
# consequential damages in connection with, or arising out of, the       #
# furnishing, performance, or use of these programs.                     #
##########################################################################
