﻿# nonprintchars.py

""" Uzyskiwanie listy znaków niedrukowalnych """
# Andrzej Grażyński
# Copyright (C) 2019 Helion Publishing
    
import sys    
              
def is_printable(code):
    return  (f'{code:c}').isprintable()
    
def is_nonprintable(code):
    return not is_printable(code)

MAXLIMIT = 0x110000 

limit = input('Podaj górną granicę kodu: ')
if limit.isdecimal():
    limit = int(limit)
    if limit > MAXLIMIT:
        limit = MAXLIMIT
else:
    limit = 0         
        
if limit <= 0:        
    print('Niepoprawna wartość\n')
    sys.exit()    
    
printables = list(filter(is_nonprintable, range(limit+1)))  
printables += [0]   # wartownik

lastprintable = -2
lowerprintable = -1
ranges = []

maxitemwidth = 0 
for i in printables:
   if i != lastprintable + 1:
         if lowerprintable >= 0:
            newrange = (lowerprintable, lastprintable)
            itemwidth = len(f'{lowerprintable}-{lastprintable}')
            if itemwidth > maxitemwidth:
                maxitemwidth = itemwidth     
            ranges.append(newrange)
         lowerprintable = i
   lastprintable = i      

print(f'\nZnaki niedrukowalne z zakresu 0 - {limit}:')

maxfslen = 0
for rmode in range(2):
    for dublet in ranges:
        istart = dublet[0]
        iend   = dublet[1]
        if istart == iend:
            fs1 = f'{istart} (0x{istart:<x}))'
            fs2 = chr(istart)
        else:
            fs1 = f'{istart} (0x{istart:<x})  - {iend} (0x{iend:<x})'
            fs2 = chr(istart) + ' - ' + chr(iend)
        if rmode == 0:
            maxfslen = max(maxfslen, len(fs1))   
        else:
            print(fs1.center(maxfslen), ' ', fs2)
