# Rozdzia 16. Big Data: Hadoop, Spark, NoSQL i IoT
## 16.2. Relacyjne bazy danych i jzyk SQL
#### 16.2.4.1. Tworzenie bazy danych
sqlite3 books.db < books.sql

#### 16.2.4.2. czenie z baz danych w Pythonie
import sqlite3
connection = sqlite3.connect('books.db')

#### 16.2.4.3. Tabela authors 
##### 16.2.4.3.1. Ogldanie zawartoci tabeli
import pandas as pd
pd.options.display.max_columns = 10
pd.read_sql('SELECT * FROM authors', connection,
            index_col=['id'])

#### 16.2.4.4. Tabela titles 
pd.read_sql('SELECT * FROM titles', connection)

#### 16.2.4.5. Tabela author_ISBN 
df = pd.read_sql('SELECT * FROM author_ISBN', connection)
df.head()

### 16.2.6. Zapytania SQL SELECT
pd.read_sql('SELECT first, last FROM authors', connection)

#### 16.2.6.1. Klauzula WHERE
pd.read_sql("""SELECT title, edition, copyright
               FROM titles
               WHERE copyright > '2016'""", connection)

##### 16.2.6.1.1. Dopasowywanie wzorca  zero lub wicej znakw
pd.read_sql("""SELECT id, first, last
               FROM authors
               WHERE last LIKE 'D%'""",
            connection, index_col=['id'])

##### 16.2.6.1.2. Dopasowywanie wzorca  dowolny znak
pd.read_sql("""SELECT id, first, last
               FROM authors
               WHERE first LIKE '_b%'""",
            connection, index_col=['id'])

####16.2.6.2. Klauzula ORDER BY
pd.read_sql('SELECT title FROM titles ORDER BY title ASC',
            connection)

##### 16.2.6.2.1. Sortowanie wzgldem wielu kolumn
pd.read_sql("""SELECT id, first, last
               FROM authors
               ORDER BY last, first""",
            connection, index_col=['id'])

pd.read_sql("""SELECT id, first, last
               FROM authors
               ORDER BY last DESC, first ASC""",
            connection, index_col=['id'])

#### 16.2.6.3. Kombinacja klauzul WHERE i ORDER BY
pd.read_sql("""SELECT isbn, title, edition, copyright
               FROM titles
               WHERE title LIKE '%How to Program'
               ORDER BY title""", connection)

#### 16.2.6.4. Zczenia tabel  INNER JOIN
pd.read_sql("""SELECT first, last, isbn
               FROM authors
               INNER JOIN author_ISBN
               ON authors.id = author_ISBN.id
               ORDER BY last, first""", connection).head()

### 16.2.7. Instrukcja INSERT INTO
cursor = connection.cursor()
cursor = cursor.execute("""INSERT INTO authors (first, last)
                                   VALUES ('Sue', 'Red')""")

pd.read_sql('SELECT id, first, last FROM authors',
             connection, index_col=['id'])

### 16.2.8. Instrukcja UPDATE
cursor = cursor.execute("""UPDATE authors SET last='Black'
                           WHERE last='Red' AND first='Sue'""")
cursor.rowcount
pd.read_sql('SELECT id, first, last FROM authors',
            connection, index_col=['id'])

### 16.2.9. Instrukcja DELETE FROM
cursor = cursor.execute('DELETE FROM authors WHERE id=6')
cursor.rowcount
pd.read_sql('SELECT id, first, last FROM authors',
            connection, index_col=['id'])

### 16.2.10. Zamykanie bazy danych
connection.close()
