## 16.6. Spark
#### 16.6.2.2. Instalowanie Dockera
# https://www.docker.com/products/docker-desktop
# https://docs.docker.com/machine/drivers/virtualbox/
# https://docs.docker.com/install/overview/
# https://docs.docker.com/get-started/

#### 16.6.2.3. Kontenery Jupytera
# https://jupyter-docker-stacks.readthedocs.io/en/latest/index.html

#### 16.6.2.4. Uruchamianie kontenera Jupytera
docker run -p 8888:8888 -p 4040:4040 -it --user root \
   -v <pena cieka do folderu>:/home/jovyan/work \
   jupyter/pyspark-notebook:14fdfbf9cfc1 start.sh jupyter lab

jupyter/pyspark-notebook:14fdfbf9cfc1

#### 16.6.2.5. Otwieranie JupyterLaba w przegldarce WWW
# http://(bb00eb337630 or 127.0.0.1):8888/?token=
#     9570295e90ee94ecef75568b95545b7910a8f5502e6f5680

# http://localhost:8888/lab

#### 16.6.2.6. Dostp do dockerowego kontenera z jego wiersza polece
docker ps
conda install -c conda-forge nltk textblob

#### 16.6.2.7. Zatrzymywanie i restartowanie dockerowego kontenera
docker stop <nazwa kontenera>
docker restart <nazwa kontenera>
# https://kitematic.com/
# https://docs.docker.com/kitematic/userguide/

#### 16.6.3.1. adowanie listy sw nieznaczcych NLTK
import nltk
nltk.download('stopwords')
# --------------------------------
from nltk.corpus import stopwords
stop_words = stopwords.words('english')

####16.6.3.2. Konfigurowanie kontekstu
from pyspark import SparkConf
configuration = SparkConf().setAppName('RomeoAndJulietCounter')\
.setMaster('local[*]')
from pyspark import SparkContext
sc = SparkContext(conf=configuration)

#### 16.6.3.3. Odczytywanie pliku tekstowego i mapowanie jego treci na listy sw
from textblob.utils import strip_punc
tokenized = sc.textFile('RomeoAndJuliet.txt')\
             .map(lambda line: strip_punc(line, all=True).lower())\
             .flatMap(lambda line: line.split())

#### 16.6.3.4. Usuwanie sw nieznaczcych
filtered = tokenized.filter(lambda word: word not in stop_words)

#### 16.6.3.5. Zliczanie pozostaych sw
from operator import add
word_counts = filtered.map(lambda word: (word, 1)).reduceByKey(add)

#### 16.6.3.6. Uwzgldnianie sw, ktre wystpiy co najmniej 60 razy
filtered_counts = word_counts.filter(lambda item: item[1] >= 60)

#### 16.6.3.7. Sortowanie sw i wypisywanie wynikw
from operator import itemgetter
sorted_items = sorted(filtered_counts.collect(),
                           key=itemgetter(1), reverse=True)

max_len = max([len(word) for word, count in sorted_items])
for word, count in sorted_items:
    print(f'{word:>{max_len}}: {count}')

#### 16.6.4.1. Tworzenie klastera Apache Spark przy uyciu portalu Azure
# https://docs.microsoft.com/en-us/azure/hdinsight/spark/apache-spark-jupyter-spark-sql-use-portal

#### 16.6.4.2. Instalowanie bibliotek w klasterze
/usr/bin/anaconda/envs/py35/bin/conda list
# http://deitel.com/bookresources/IntroToPython/install_libraries.sh
#### 16.6.4.3. Kopiowanie pliku RomeoAndJuliet.txt do klastera HDInsight
scp RomeoAndJuliet.txt sshuser@<nazwa klastera>-ssh.azurehdinsight.net:
ssh sshuser@<nazwa klastera>-ssh.azurehdinsight.net
hadoop fs -copyFromLocal RomeoAndJuliet.txt
    /example/data/RomeoAndJuliet.txt

#### 16.6.4.4. Notatnik Jupytera w HDInsight
https://jupyter-notebook.readthedocs.io/en/stable/examples/Notebook/Notebook%20Basics.html

#### 16.6.4.6. Przystosowanie notatnika do Azure
nltk.download('stopwords')
nltk.download('stopwords', download_dir='.')
nltk.data.path.append('.')
#---------------------------------
wasb:///example/data/RomeoAndJuliet.txt
print('{:>{width}}: {}'.format(word, count, width=max_len))
#---------------------------------
#https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-group-portal
