# Rozdzia 14. Uczenie maszynowe: klasyfikacja, regresja i klasteryzacja 
## 14.2. Analiza przypadku: algorytm k najbliszych ssiadw  klasyfikacja w zbiorze Digits. Cz pierwsza
### 14.2.5. Wczytanie zbioru danych
from sklearn.datasets import load_digits
digits = load_digits()

### 14.2.6. Informacja o zbiorze
http://archive.ics.uci.edu/ml/datasets/Optical+Recognition+of+Handwritten+Digits
--------------------------------
print(digits.DESCR)

### 14.2.7. Tablica prbek i tablica celu
digits.target[::100]
digits.data.shape
digits.target.shape

### 14.2.8. Przykadowy obraz-prbka
digits.images[13]

### 14.2.9. Przygotowanie danych dla scikit-learn 
digits.data[13]

#### 14.2.10.1. Tworzenie diagramu
import matplotlib.pyplot as plt
figure, axes = plt.subplots(nrows=4, ncols=6, figsize=(6, 4))

#### 14.2.10.2. Wywietlenie obrazkw i usunicie etykiet na osiach
for item in zip(axes.ravel(), digits.images, digits.target):
    axes, image, target = item
    axes.imshow(image, cmap=plt.cm.gray_r)
    axes.set_xticks([]) # usu znaczniki z osi x
    axes.set_yticks([]) # usu znaczniki z osi y
    axes.set_title(target)

plt.tight_layout()
--------------------------------
https://matplotlib.org/examples/color/colormaps_reference.html

### 14.2.11. Podzia danych na treningowe i testowe
from sklearn.model_selection import train_test_split
X_train, X_test, y_train, y_test = train_test_split(
          digits.data, digits.target, random_state=11)

#### 14.2.11.1. Proporcja podziau
X_train.shape
X_test.shape
X_train, X_test, y_train, y_test = train_test_split(
    digits.data, digits.target, random_state=11, test_size=0.20)

### 14.2.12. Tworzenie modelu
from sklearn.neighbors import KNeighborsClassifier
knn = KNeighborsClassifier()

### 14.2.13. Trenowanie modelu
knn.fit(X=X_train, y=y_train)
KNeighborsClassifier(algorithm='auto', leaf_size=30, metric='minkowski',
                     metric_params=None, n_jobs=None, n_neighbors=5, p=2,
                     weights='uniform')

--------------------------------
http://scikit-learn.org/stable/modules/generated/sklearn.neighbors.KNeighborsClassifier.html

### 14.2.14. Przewidywanie klas docelowych
prognoza = knn.predict(X=X_test)
oczekiwane = y_test
prognoza[:20]
oczekiwane[:20]
nietrafione = [(p, e) for (p, e) in zip(prognoza, oczekiwane) if p != e]
nietrafione

## 14.3. Analiza przypadku: algorytm k  najbliszych ssiadw  klasyfikacja w zbiorze Digits. Cz druga
### 14.3.1. Metoda score estymatora 
print(f'{knn.score(X_test, y_test):.2%}')

### 14.3.2. Macierz pomyek
from sklearn.metrics import confusion_matrix
chybienia = confusion_matrix(y_true=oczekiwane, y_pred=prognoza)
chybienia

### 14.3.3. Raport z klasyfikacji
from sklearn.metrics import classification_report
nazwy = [str(digit) for digit in digits.target_names]
print(classification_report(oczekiwane, prognoza,
                            target_names=nazwy))
--------------------------------
http://scikit-learn.org/stable/modules/generated/sklearn.metrics.classification_report.html

### 14.3.4. Wizualizacja macierzy pomyek
import pandas as pd
chybienia_df = pd.DataFrame(chybienia, index=range(10),
                            columns=range(10))

import seaborn as sns
axes = sns.heatmap(chybienia_df, annot=True,
                           cmap='nipy_spectral_r')

#### 14.3.5.1. Klasa KFold 
from sklearn.model_selection import KFold
kfold = KFold(n_splits=10, random_state=11, shuffle=True)

#### 14.3.5.2. Obiekt KFold i funkcja cross_val_score 
from sklearn.model_selection import cross_val_score
scores = cross_val_score(estimator=knn, X=digits.data,
                     y=digits.target, cv=kfold)

scores
print(f'rednia dokadno: {scores.mean():.2%}')
print(f'Odchylenie standardowe dokadnoci: {scores.std():.2%}')

### 14.3.6. Wybr najlepszego modelu
from sklearn.svm import SVC
from sklearn.naive_bayes import GaussianNB

estimators = {
    'KNeighborsClassifier': knn,
    'SVC': SVC(gamma='scale'),
    'GaussianNB': GaussianNB()}

for estimator_name, estimator_object in estimators.items():
    kfold = KFold(n_splits=10, random_state=11, shuffle=True)
    scores = cross_val_score(estimator=estimator_object,
        X=digits.data, y=digits.target, cv=kfold)
    print(f'{estimator_name:>20}: ' +
          f'rednia dokadno={scores.mean():.2%}; ' +
          f'odchylenie standardowe dokadnoci={scores.std():.2%}')
 

#### 14.3.6.1. Estymatory biblioteki scikit-learn
https://scikit-learn.org/stable/tutorial/machine_learning_map/index.html

### 14.3.7. Dostrajanie hiperparametru
for k in range(1, 20, 2):
    kfold = KFold(n_splits=10, random_state=11, shuffle=True)
    knn = KNeighborsClassifier(n_neighbors=k)
    scores = cross_val_score(estimator=knn,
        X=digits.data, y=digits.target, cv=kfold)
    print(f'k={k:<2}; rednia dokadno={scores.mean():.2%}; ' +
          f'odchylenie standardowe={scores.std():.2%}')
