﻿# tweetlistener.py

"""Podklasa klasy bazowej tweepy.StreamListener 
   przetwarzająca nadchodzące tweety."""
import tweepy
from textblob import TextBlob

class TweetListener(tweepy.StreamListener):
    """Obsługuje strumień nadchodzących tweetów."""

    def __init__(self, api, limit=10):
        """Utworzenie zmiennych obiektu kontrolujących liczbę tweetów."""
        self.tweet_count = 0
        self.TWEET_LIMIT = limit
        super().__init__(api)  # wywołanie __init__ z nadklasy 

    def on_connect(self):
        """Metoda wywoływana, gdy połączenie zostaje pomyślnie
           nawiązane. Możliwe staje się wykonywanie zadań wymagających 
           tego połączenia"""
        print('Nawiązano połączenie\n')

    def on_status(self, status):
        """Metoda wywoływana, gdy Twitter dostarcza nowy tweet"""
      
        # pobranie treści tweetu
        try:  
            tweet_text = status.extended_tweet.full_text
        except: 
            tweet_text = status.text

        print(f'Nazwa ekranowa: {status.user.screen_name}:')
        print(f'         Język: {status.lang}')
        print(f'         Treść: {tweet_text}')

        if status.lang != 'en':
            print(f'   Tłumaczenie: {TextBlob(tweet_text).translate()}')

        print()
        self.tweet_count += 1  # licznik przetworzonych tweetów

        # gdy osiągnięty zostanie limit przetworzonych tweetów
        # (TWEET_LIMIT) zwróć False w celu przerwania strumieniowania,
        # w przeciwnym razie zwróć True.
        return self.tweet_count <= self.TWEET_LIMIT

##########################################################################
# (C) Copyright 2019 by Deitel & Associates, Inc. and                    #
# Pearson Education, Inc. All Rights Reserved.                           #
#                                                                        #
# DISCLAIMER: The authors and publisher of this book have used their     #
# best efforts in preparing the book. These efforts include the          #
# development, research, and testing of the theories and programs        #
# to determine their effectiveness. The authors and publisher make       #
# no warranty of any kind, expressed or implied, with regard to these    #
# programs or to the documentation contained in these books. The authors #
# and publisher shall not be liable in any event for incidental or       #
# consequential damages in connection with, or arising out of, the       #
# furnishing, performance, or use of these programs.                     #
##########################################################################
