﻿# karta_dataclass.py


"""Klasa danych dla klasy Karta z atrybutami klasowymi,
atrybutami danych, metodami generowanymi automatycznie 
i metodami definiowanymi explicite."""

from dataclasses import dataclass
from typing import ClassVar, List

@dataclass
class Karta:
    FACES: ClassVar[List[str]] = [
        'As', '2', '3', '4', '5', '6',
         '7', '8', '9', '10', 'Walet', 'Dama', 'Król']
             
    SUITS: ClassVar[List[str]] = ['Kier', 'Karo', 'Trefl', 'Pik']
    
    FACE_IMAGE_MARKS: ClassVar[List[str]] = [
        'Ace', '2', '3', '4', '5', '6',
         '7', '8', '9', '10', 'Jack', 'Queen', 'King']
             
    SUIT_IMAGE_MARKS: ClassVar[List[str]] = [
        'Hearts', 'Diamonds', 'Clubs', 'Spades']         


    face: str
    suit: str

    @property
    def nazwa_pliku_obrazu(self):
        """Zwraca nazwę pliku z obrazem karty."""
    
        if self.face in Karta.FACES:
            ndx = Karta.FACES.index(self.face)
            face_image_mark = Karta.FACE_IMAGE_MARKS[ndx]
        else:
            face_image_mark = '?'    

        if self.suit in Karta.SUITS:
            ndx = Karta.SUITS.index(self.suit)
            suit_image_mark = Karta.SUIT_IMAGE_MARKS[ndx]
        else:
            suit_image_mark = '?'  
        
        image_file_name = face_image_mark + '_of_' + suit_image_mark + '.png'
        if image_file_name.find('?') >= 0:
            image_file_name = 'unknown.png' 
        return image_file_name      
    
        
    def __str__(self):
        """Zwraca przyjazną reprezentację tekstową karty."""
        return f'{self.face} {self.suit}'
        
    def __format__(self, format):
        """Zwraca sformatowaną reprezentację tekstową karty"""
        return f'{str(self):{format}}'

##########################################################################
# (C) Copyright 2019 by Deitel & Associates, Inc. and                    #
# Pearson Education, Inc. All Rights Reserved.                           #
#                                                                        #
# DISCLAIMER: The authors and publisher of this book have used their     #
# best efforts in preparing the book. These efforts include the          #
# development, research, and testing of the theories and programs        #
# to determine their effectiveness. The authors and publisher make       #
# no warranty of any kind, expressed or implied, with regard to these    #
# programs or to the documentation contained in these books. The authors #
# and publisher shall not be liable in any event for incidental or       #
# consequential damages in connection with, or arising out of, the       #
# furnishing, performance, or use of these programs.                     #
##########################################################################
