﻿# accountdoctest.py

"""Definicja klasy Account."""
from decimal import Decimal
class Account:
    """Klasa Account reprezentująca saldo konta bankowego."""
    
    def __init__(self, name, balance):
        """Zainicjowanie obiektu konta.
        
        >>> konto_1 = Account('John Green', Decimal('50.00'))
        >>> konto_1.name
        'John Green'
        >>> konto_1.balance
        Decimal('50.00')

        Stan konta nie może być ujemny.
        >>> konto_2 = Account('John Green', Decimal('-50.00'))
        Traceback (most recent call last):
            ...
        ValueError: Saldo początkowe nie może być ujemne.
        """

        # zgłoś błąd, gdy saldo konta jest ujemne
        if balance < Decimal('0.00'):
            raise ValueError('Saldo początkowe nie może być ujemne.')

        self.name = name
        self.balance = balance

    def deposit(self, amount):
        """Wpłata pieniędzy na konto."""

        # zgłoś błąd, gdy wpłacana kwota jest ujemna
        if amount < Decimal('0.00'):
            raise ValueError('Nie można wpłacić ujemnej kwoty.')

        self.balance += amount

if __name__ == '__main__':
    import doctest
    doctest.testmod(verbose=True)
#    doctest.testmod()
##########################################################################
# (C) Copyright 2019 by Deitel & Associates, Inc. and                    #
# Pearson Education, Inc. All Rights Reserved.                           #
#                                                                        #
# DISCLAIMER: The authors and publisher of this book have used their     #
# best efforts in preparing the book. These efforts include the          #
# development, research, and testing of the theories and programs        #
# to determine their effectiveness. The authors and publisher make       #
# no warranty of any kind, expressed or implied, with regard to these    #
# programs or to the documentation contained in these books. The authors #
# and publisher shall not be liable in any event for incidental or       #
# consequential damages in connection with, or arising out of, the       #
# furnishing, performance, or use of these programs.                     #
##########################################################################
