## 14.4. Analiza przypadku: prosta regresja liniowa na szeregu czasowym
%matplotlib

### 14.4.1. Wczytanie danych temperaturowych do ramki DataFrame
import pandas as pd
nyc = pd.read_csv('ave_hi_nyc_jan_1895-2018.csv')
nyc.columns = ['Data', 'Temperatura', 'Odchylenie']
nyc.Data = nyc.Data.floordiv(100)
nyc.head(3)

### 14.4.2. Podzia prbek na treningowe i testowe
from sklearn.model_selection import train_test_split

X_train, X_test, y_train, y_test = train_test_split(
     nyc.Data.values.reshape(-1, 1), nyc.Temperatura.values,
     random_state=11)

X_train.shape
X_test.shape

### 14.4.3. Trenowanie modelu
from sklearn.linear_model import LinearRegression
linear_regression = LinearRegression()
linear_regression.fit(X=X_train, y=y_train)
--------------------------------
http://scikit-learn.org/stable/modules/generated/sklearn.linear_model.LinearRegression.html
linear_regression.coef_
linear_regression.intercept_

### 14.4.4. Testowanie modelu
prognozowana = linear_regression.predict(X_test)
oczekiwana = y_test

for p, e in zip(prognozowana[::5], oczekiwana[::5]):
    print(f'prognozowana: {p:.2f}, oczekiwana: {e:.2f}')


### 14.4.5. Prognozowanie temperatury
prognoza = (lambda x: linear_regression.coef_ * x +
             linear_regression.intercept_)

for rok in [1880, 1885, 1890, 2019, 2020, 2021]:
    print(rok, prognoza(rok))    

### 14.4.6. Wizualizacja danych i linia regresji
import seaborn as sns

axes = sns.scatterplot(data=nyc, x='Data', y='Temperatura',
         hue='Temperatura', palette='winter', legend=False)

axes.set_ylim(10, 70)
--------------------------------
import numpy as np
x = np.array([min(nyc.Data.values), max(nyc.Data.values)])
y = prognoza(x)

import matplotlib.pyplot as plt
linia = plt.plot(x, y)

### 14.4.7. Niedouczenie i przeuczenie modelu
https://en.wikipedia.org/wiki/Overfitting
https://pl.wikipedia.org/wiki/Nadmierne_dopasowanie
https://machinelearningmastery.com/overfitting-and-underfitting-with-machine-learning-algorithms/
