# Rozdzia 9. Pliki i wyjtki
## 9.3.1. Zapis do pliku tekstowego

with open('accounts.txt', mode='w') as accounts:
    accounts.write('100 Jones 24.98\n')
    accounts.write('200 Doe 345.67\n')
    accounts.write('300 White 0.00\n')
    accounts.write('400 Stone -42.16\n')
    accounts.write('500 Rich 224.62\n')
--------------------------------  
bilans = [
         '100 Jones 24.98',
         '200 Doe 345.67', 
         '300 White 0.00',           
         '400 Stone -42.16',
         '500 Rich 224.62' 
         ]
         
with open('accounts.txt', mode='w') as accounts:
    for s in bilans:
        print(s, file=accounts)         
   
#### 9.3.1.4. Zawarto pliku accounts.txt
100 Jones 24.98
200 Doe 345.67
300 White 0.00
400 Stone -42.16
500 Rich 224.62

### 9.3.2. Odczyt danych z pliku tekstowego
with open('accounts.txt', mode='r') as accounts:
    print(f'{"Nr konta":<10}{"Nazwa":<10}{"Stan konta":>10}')
    for rekord in accounts:
        nr_konta, nazwa, stan_konta = rekord.split()
        print(f'{nr_konta:<10}{nazwa:<10}{stan_konta:>10}')
