# fig04_02.py
#-*- coding: 1250 -*-
"""Symulacja gry w koci (craps)."""
import random

def rzut_kostkami():
    """Symuluje rzut dwiema kostkami i zwraca uzyskany wynik
       w postaci dwuelementowej krotki"""
    oczka_1 = random.randrange(1, 7)
    oczka_2 = random.randrange(1, 7)
    return (oczka_1, oczka_2)  # spakuj dwie wartoci w krotk

def wypisz_rzut(oba_oczka):
    """Wywietla wynik jednego rzutu oddzielnie dla obu kostek"""
    oczka_1, oczka_2 = oba_oczka  # wypakowanie wartoci skadowych z krotki
    print(f'Wynik rzutu {oczka_1} + {oczka_2} = {sum(oba_oczka)}')

wynik_rzutu = rzut_kostkami()  # pierwszy rzut
wypisz_rzut(wynik_rzutu)

# okrel status gry - wygran, przegran albo punkt
# na podstawie pierwszego rzutu
suma_oczek = sum(wynik_rzutu)

if suma_oczek in (7, 11):  # wygrana
    status_gry = 'WYGRANA'
elif suma_oczek in (2, 3, 12):  # przegrana
    status_gry = 'PRZEGRANA'
else:  # zapamitanie wartoci punktu
    status_gry = 'KONTYNUACJA'
    punkt = suma_oczek
    print('Punkt', punkt)

# kontynuowanie rzutw a do osignicia punktu
# lub przegranej
while status_gry == 'KONTYNUACJA':
    wynik_rzutu = rzut_kostkami()
    wypisz_rzut(wynik_rzutu)
    suma_oczek = sum(wynik_rzutu)

    if suma_oczek == punkt:  # wygrana - osignicie punktu
        status_gry = 'WYGRANA'
    elif suma_oczek == 7:  # przegrana - uzyskanie 7
        status_gry = 'PRZEGRANA'

# wypisanie kocowego statusu gry
if status_gry == 'WYGRANA':
    print('Gracz wygrywa')
else:
    print('Gracz przegrywa')

##########################################################################
# (C) Copyright 2019 by Deitel & Associates, Inc. and                    #
# Pearson Education, Inc. All Rights Reserved.                           #
#                                                                        #
# DISCLAIMER: The authors and publisher of this book have used their     #
# best efforts in preparing the book. These efforts include the          #
# development, research, and testing of the theories and programs        #
# to determine their effectiveness. The authors and publisher make       #
# no warranty of any kind, expressed or implied, with regard to these    #
# programs or to the documentation contained in these books. The authors #
# and publisher shall not be liable in any event for incidental or       #
# consequential damages in connection with, or arising out of, the       #
# furnishing, performance, or use of these programs.                     #
##########################################################################
