﻿## 10.6. Analiza przypadku: symulacja tasowania i rozdawania kart
#### 10.6.1.1. Tworzenie i tasowanie kart
from talia import TaliaKart
talia_kart = TaliaKart()
print(talia_kart)
talia_kart.tasuj()
print(talia_kart)

#### 10.6.1.2. Rozdawanie kart
talia_kart.kolejna_karta_z_talii()

#### 10.6.1.3. Inne cechy klasy „Karta”
karta = talia_kart.kolejna_karta_z_talii()
str(karta)
karta.nazwa_pliku_obrazu

### 10.6.7. Wyświetlanie obrazów kart
from talia import TaliaKart
talia_kart = TaliaKart()

#### 10.6.7.1. Włączanie obsługi Matplotliba
%matplotlib

#### 10.6.7.2. Ścieżka bazowa pliku graficznego
from pathlib import Path
path = Path('.').joinpath('card_images')

#### 10.6.7.3. Importowanie modułów Matplotliba
import matplotlib.pyplot as plt
import matplotlib.image as mpimg

#### 10.6.7.4. Tworzenie obiektów okna wykresu i osi
figure, axes_list = plt.subplots(nrows=4, ncols=13)

#### 10.6.7.5. Konfigurowanie obiektów osi i wyświetlanie  obrazów
for axes in axes_list.ravel():
    axes.get_xaxis().set_visible(False)
    axes.get_yaxis().set_visible(False)
    image_name = talia_kart.kolejna_karta_z_talii().nazwa_pliku_obrazu
    img = mpimg.imread(str(path.joinpath(image_name).resolve()))
    axes.imshow(img)

#### 10.6.7.6. Maksymalizacja obrazów
figure.tight_layout()

#### 10.6.7.7. Tasowanie i ponowne rozdanie
talia_kart.tasuj()

for axes in axes_list.ravel():
    axes.get_xaxis().set_visible(False)
    axes.get_yaxis().set_visible(False)
    image_name = talia_kart.kolejna_karta_z_talii().nazwa_pliku_obrazu
    img = mpimg.imread(str(path.joinpath(image_name).resolve()))
    axes.imshow(img)
