﻿# Rozdział 12. Eksploracja masowych danych — Twitter
### 12.6.1. Instalowanie bibliotek „Tweepy” i „Geopy ”
pip install tweepy==3.7
conda install -c conda-forge geopy

## 12.7. Uwierzytelnianie za pomocą biblioteki „Tweepy” 
import tweepy
import keys

### 12.7.1. Obiekt uwierzytelniający „OAuthHandler”
auth = tweepy.OAuthHandler(
           keys.consumer_key, keys.consumer_secret)

auth.set_access_token(
           keys.access_token, keys.access_token_secret)

### 12.7.2. Obiekt API — interakcja z API Twittera
api = tweepy.API(
                 auth, wait_on_rate_limit=True, 
                 wait_on_rate_limit_notify=True)  

## 12.8. Informacja o koncie Twittera
nasa = api.get_user('nasa')

### 12.8.1. Podstawowe parametry
nasa.id
nasa.name
nasa.screen_name
nasa.description

### 12.8.2. Ostatnio wysłany tweet
nasa.status.text

### 12.8.3. Obserwujący
nasa.followers_count

### 12.8.4. Znajomi
nasa.friends_count

### 12.8.5. Informacje o sobie
moje_konto = api.me()

## 12.9. Kursory biblioteki „Tweepy”
### 12.9.1. Lista obserwujących
obserwatorzy = []

#### 12.9.1.1. Tworzenie kursora
cursor = tweepy.Cursor(api.followers, screen_name='nasa')

#### 12.9.1.2. Pobieranie wyników
for konto in cursor.items(10):                 
    obserwatorzy.append(konto.screen_name)

print('Obserwatorzy:',
      ' '.join(sorted(obserwatorzy, key=lambda s: s.lower())))


### 12.9.2. Informacje o znajomych
znajomi = []
cursor = tweepy.Cursor(api.friends, screen_name='nasa')
for znajomy in cursor.items(10):
    znajomi.append(znajomy.screen_name)

print('Znajomi:',
      ' '.join(sorted(znajomi, key=lambda s: s.lower())))

### 12.9.3. Najnowsze tweety z konta
nasa_tweets = api.user_timeline(screen_name='nasa', count=3)

for tweet in nasa_tweets:
    print(f'{tweet.user.screen_name}: {tweet.text}\n')
    
#### 12.9.3.1. Moje najnowsze tweety
moje_tweety = api.home_timeline()
moje_tweety

## 12.10. Przeszukiwanie niedawnych tweetów
### 12.10.1. Funkcja użytkowa „print_tweets” 
from tweetutilities import print_tweets
       
### 12.10.2. Wyszukiwanie określonych słów
tweets = api.search(q='Mars Opportunity Rover', count=3)
print_tweets(tweets)

### 12.10.3. Operatory wyszukiwania
tweets = api.search(q='from:nasa since:2020-02-01', count=3)
print_tweets(tweets)

#### 12.10.3.1. Wyszukiwanie hashtagów
tweets = api.search(q='#collegefootball', count=2)
print_tweets(tweets)

## 12.11. Odkrywanie trendów — Twitter Trends API
### 12.11.1. Umiejscawianie trendów
trends_available = api.trends_available()
len(trends_available)
trends_available[0]
trends_available[1]

#### 12.11.2.1. Trendy światowe
world_trends = api.trends_place(id=1)
trends_list = world_trends[0]['trends']
trends_list[0]
trends_list = [t for t in trends_list if t['tweet_volume']]

from operator import itemgetter
trends_list.sort(key=itemgetter('tweet_volume'), reverse=True)

for trend in trends_list[:5]:
    print(trend['name'])

#### 12.11.2.2. Trendy lokalne — Nowy Jork  
nyc_trends = api.trends_place(id=2459115) # WOEID Nowego Jorku WOEID
nyc_list = nyc_trends[0]['trends']
nyc_list = [t for t in nyc_list if t['tweet_volume']]
nyc_list.sort(key=itemgetter('tweet_volume'), reverse=True)

for trend in nyc_list[:5]:
    print(trend['name'])

### 12.11.3. Tworzenie chmury słów na podstawie listy trendów
topics = {}

for trend in nyc_list:
    topics[trend['name']] = trend['tweet_volume']

from wordcloud import WordCloud

wordcloud = WordCloud(width=1600, height=900,
              prefer_horizontal=0.5, min_font_size=10, colormap='prism',
              background_color='white')

wordcloud = wordcloud.fit_words(topics)

wordcloud = wordcloud.to_file('TrendingTwitter.png')

## 12.12. Preparacja tweetów przed analizą
#### 12.12.1.1. Instalowanie biblioteki „tweet-preprocessor”
pip install tweet-preprocessor

#### 12.12.1.2. Czyszczenie tweetu 
import preprocessor as p
p.set_options(p.OPT.URL, p.OPT.RESERVED)
tweet_text = 'RT A sample retweet with a URL https://nasa.gov'
p.clean(tweet_text)

## 12.13. Strumieniowanie tweetów — Twitter Streaming API
#### 12.13.2.1. Uwierzytelnianie 
import tweepy
import keys
auth = tweepy.OAuthHandler(keys.consumer_key,
                           keys.consumer_secret)

auth.set_access_token(keys.access_token,
                      keys.access_token_secret)

api = tweepy.API(auth, wait_on_rate_limit=True,
                 wait_on_rate_limit_notify=True)

#### 12.13.2.2. Tworzenie obiektu „TweetListener”
from tweetlistener import TweetListener
tweet_listener = TweetListener(api)

#### 12.13.2.3. Tworzenie strumienia 
tweet_stream = tweepy.Stream(auth=api.auth,
                  listener=tweet_listener)

#### 12.13.2.4. Uruchomienie strumieniowania
tweet_stream.filter(track=['Mars Rover'], is_async=True)

## 12.14. Tweety i analiza sentymentu — klasa „SentimentListener”
run sentimentlistener.py football 10

## 12.15. Mapy i geokodowanie
### 12.15.3. Biblioteki „Folium  ” i „Leaflet.js” 
pip install folium
#### 12.15.5.1. Tworzenie obiektu API
from tweetutilities import get_API
api = get_API()

#### 12.15.5.2. Kolekcje wymagane przez obiekt „LocationListener”
tweets = []
counts = {'total_tweets': 0, 'locations': 0}

#### 12.15.5.3. Tworzenie obiektu „LocationListener”
from locationlistener import LocationListener
location_listener = LocationListener(api, counts_dict=counts,
                    tweets_list=tweets, topic='football', limit=50)

#### 12.15.5.4. Rozpoczynanie strumieniowania
import tweepy
stream = tweepy.Stream(auth=api.auth, listener=location_listener)
stream.filter(track=['football'], languages=['en'], is_async=False)

#### 12.15.5.5. Statystyka przechwyconych tweetów
counts['total_tweets'] # liczba wszystkich tweetów
counts['locations'] # liczba tweetów zlokalizowanych
print(f'{counts["locations"] / counts["total_tweets"]:.1%}')

#### 12.15.5.6. Geokodowanie lokalizacji
from tweetutilities import get_geocodes
bad_locations = get_geocodes(tweets)

#### 12.15.5.7. Statystyka nierozpoznanych lokalizacji
bad_locations
print(f'{bad_locations / counts["locations"]:.1%}')

#### 12.15.5.8. Czyszczenie danych
import pandas as pd
df = pd.DataFrame(tweets)
df = df.dropna()

#### 12.15.5.9. Tworzenie mapy
import folium
usmap = folium.Map(location=[39.8283, -98.5795],
                   tiles='Stamen Terrain',
                   zoom_start=5, detect_retina=True)

#### 12.15.5.10. Tworzenie markerów lokalizacji
for t in df.itertuples():
    text = ': '.join([t.screen_name, t.text])
    popup = folium.Popup(text, parse_html=True)
    marker = folium.Marker(
                            (t.latitude, t.longitude),
                            popup=popup
                          )
marker.add_to(usmap)

#### 12.15.5.11. Zapisywanie mapy jako strony WWW
usmap.save('tweet_map.html')
