﻿## 5.15. Natywne filtrowanie, mapowanie i redukcja
### 5.15.1. Wbudowana funkcja „filter”
liczby = [10, 3, 7, 1, 9, 4, 2, 8, 5, 6]

def jest_nieparzyste(x):
    """Zwraca True tylko dla nieparzystych x."""
    return x % 2 != 0

list(filter(jest_nieparzyste, liczby))
[element for element in liczby if jest_nieparzyste(element)]

### 5.15.2. Wyrażenia lambda
list(filter(lambda x: x % 2 != 0, liczby))

### 5.15.3. Wbudowana funkcja „map” 
liczby = [10, 3, 7, 1, 9, 4, 2, 8, 5, 6]
list(map(lambda x: x ** 2, liczby))
--------------------------------
[element ** 2 for element in liczby]

### 5.15.4. Kombinacja natywnego filtrowania i mapowania
list(map(lambda x: x ** 2,  
          filter(lambda x: x % 2 != 0, liczby)))
--------------------------------
[x ** 2 for x in liczby if x % 2 != 0]
