﻿## 4.16 Rekurencja
### 4.16.1. Iteracyjne obliczanie silni
def silnia(n):
    r = 1
    for liczba in range(n, 0, -1):
        r *= liczba
    return r    

silnia(0)
silnia(5)
silnia(10)
silnia(50)

### 4.16.2. Rekurencyjne rozwiązywanie problemów
def silnia_recur(liczba):               
    """Zwraca wartość slini dla argumentu."""
    if liczba <= 1:  # przypadek bazowy
        return 1
    return liczba * silnia_recur(liczba - 1) # wywołanie rekurencyjne

for i in range(11):
    print(f'{i:>2}! = {silnia_recur(i)}')

### 4.16.5. Nieskończona rekurencja i przepełnienie stosu
import sys
sys.setrecursionlimit(3900)
print('Dopuszczalna głębokość rekurencji:', sys.getrecursionlimit())

def silnia_infinite(liczba):               
    return liczba * silnia_infinite(liczba - 1) 

silnia_infinite(5)
