﻿## 8.13. Wprowadzenie do Data Science: wyrażenia regularne i preparacja danych w bibliotece „Pandas”
### 8.13.2. Weryfikacja poprawności danych
import pandas as pd
kody_pocztowe = pd.Series({'Bytom': '41-900', 'Gliwice': '4410'})
kody_pocztowe
kody_pocztowe.str.match(r'\d{2}-\d{3}')
miasta = pd.Series(
  [
   'Bytom, BTM 41-900', 
   'Gliwice, centrala, GLC 44-100', 
   'Bielsko Biała, BLB 43-300 (w budowie)'
  ]
    )

miasta

wzorzec = '[A-Z]{3}[\s]+\d{2}-\d{3}'
miasta.str.contains(wzorzec)
miasta.str.match(wzorzec)

### 8.13.3. Reformatowanie danych
kontakty = [
            ['Mike Green', 'demo1@deitel.com', '5555555555'],
            ['Sue Brown', 'demo2@deitel.com', '5555551234']
           ]

kontakty_df = pd.DataFrame(kontakty,
                           columns=['Nazwisko', 'E-mail', 'Telefon'])

kontakty_df

--------------------------------
import re

def sformatuj_nr_telefonu(numer):
    result = re.fullmatch(r'(\d{3})(\d{3})(\d{4})', numer)
    return '-'.join(result.groups()) if result else numer
    
nr_telefonu_sformatowany = kontakty_df['Telefon'].map(sformatuj_nr_telefonu)
nr_telefonu_sformatowany

kontakty_df['Telefon'] = nr_telefonu_sformatowany
kontakty_df
