﻿## 6.3. Zbiory
### 6.3.1. Tworzenie zbioru w sposób bezpośredni
kolory = {'czerwony', 'pomarańczowy', 'żółty', 'zielony', 'czerwony', 'niebieski'}
kolory

### 6.3.2. Określanie liczebności zbioru
len(kolory)

### 6.3.3. Testowanie obecności elementu w zbiorze
'czerwony' in kolory
'purpurowy' in kolory
'purpurowy' not in kolory

### 6.3.4. Iterowanie po elementach zbioru
for kolor in kolory:
    print(kolor.upper(), end=' ')

### 6.3.5. Tworzenie zbioru za pomocą funkcji „set”
liczby = list(range(10)) + list(range(5))
liczby
set(liczby)
--------------------------------
set()

### 6.3.7. Porównywanie zbiorów
{1, 3, 5} == {3, 5, 1}
{1, 3, 5} == {5, 3, 1}
{1, 3, 5} != {3, 5, 1}
--------------------------------
{1, 3, 5} < {3, 5, 1}
{1, 3, 5} < {7, 3, 5, 1}
--------------------------------
{1, 3, 5} <= {3, 5, 1}
{1, 3} <= {3, 5, 1}
--------------------------------
{1, 3, 5}.issubset({3, 5, 1})
{1, 2}.issubset({3, 5, 1})
--------------------------------
{1, 3, 5} > {3, 5, 1}
{1, 3, 5, 7} > {3, 5, 1}
{1, 3, 5} >= {3, 5, 1}
{1, 3, 5} >= {3, 1}
{1, 3} >= {3, 1, 7}
{1, 3, 5}.issuperset({3, 5, 1})
{1, 3, 5}.issuperset({3, 2})

#### 6.3.8.1. Unia — operator |
{1, 3, 5} | {2, 3, 4}
{1, 3, 5}.union([20, 20, 3, 40, 40])

#### 6.3.8.2. Przecięcie — operator &
{1, 3, 5} & {2, 3, 4}
{1, 3, 5}.intersection([1, 2, 2, 3, 3, 4, 4])

#### 6.3.8.3. Różnica niesymetryczna — operator –
{1, 3, 5} - {2, 3, 4}
{2, 3, 4} - {1, 3, 5}
{1, 3, 5, 7}.difference([2, 2, 3, 3, 4, 4])

#### 6.3.8.4. Różnica symetryczna — operator ^
{1, 3, 5} ^ {2, 3, 4}
{2, 3, 4} ^ {1, 3, 5}
{1, 3, 5, 7}.symmetric_difference([2, 2, 3, 3, 4, 4])

#### 6.3.8.5. Rozłączność
{1, 3, 5}.isdisjoint({2, 4, 6})
{1, 3, 5}.isdisjoint({4, 6, 1})

#### 6.3.9.1. Matematyczne operacje modyfikujące
liczby = {1, 3, 5}
liczby |= {2, 3, 4}
liczby
--------------------------------
liczby.update(range(10))
liczby

#### 6.3.9.2. Metody dodające i usuwające elementy
liczby.add(17)
liczby.add(3)
liczby
--------------------------------
liczby.remove(3)
liczby
--------------------------------
liczby.pop()
liczby
--------------------------------
liczby.clear()
liczby

### 6.3.10. Odwzorowywanie zbiorów
liczby = [1, 2, 2, 3, 4, 5, 6, 6, 7, 8, 9, 10, 10]
parzyste = {element for element in liczby if element % 2 == 0}
parzyste
