﻿# fig06_02_counter.py

"""Zliczanie występowania słów w tekście."""

from collections import Counter

tekst = ('to jest przykładowy tekst składający się z kilku słów '
         'to jest inny przykładowy tekst zawierający większą liczbę słów')  

# zliczanie wystąpień unikalnych słów
liczniki = Counter(tekst.split())
 
print(f' {"SŁOWO":<25}LICZNIK')

wielokrotne = 0
for wyraz, licznik in sorted(liczniki.items()):
    if licznik > 1:
        wielokrotne += 1
        print(f'  {wyraz:<25}{licznik}')

print('\nLiczba unikalnych słów:', len(liczniki))
print('Liczba słów występujących wielokrotnie:', wielokrotne)
